/*****************************************************************************
* FILE:         timestampsync_ServiceTimestampsync_srv_a.cpp
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// timestampsync_tclServiceTimestampsync_srv_aIncludes: user specific code start
// timestampsync_tclServiceTimestampsync_srv_aIncludes: user specific code end

#include "timestampsync_ServiceTimestampsync_srv_a.h"
#include "timestampsync_ServiceTimestampsync_srv_aCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_SERVER_TIMESTAMPSYNC_SRV_A
#include "trcGenProj/Header/timestampsync_ServiceTimestampsync_srv_a.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define TIMESTAMPSYNC_SRV_A_SERVICE_ID              116
#define TIMESTAMPSYNC_SRV_A_FI_MAJOR_VERSION        1
#define TIMESTAMPSYNC_SRV_A_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(timestampsync_tclServiceTimestampsync_srv_a, ahl_tclBaseWork)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: timestampsync_tclServiceTimestampsync_srv_a::
*             timestampsync_tclServiceTimestampsync_srv_a(timestampsync_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
timestampsync_tclServiceTimestampsync_srv_a::timestampsync_tclServiceTimestampsync_srv_a(timestampsync_tclAppMain* poMainAppl) : 
Itimestampsync_tclServiceTimestampsync_srv_a(poMainAppl, TIMESTAMPSYNC_SRV_A_SERVICE_ID, TIMESTAMPSYNC_SRV_A_FI_MAJOR_VERSION, TIMESTAMPSYNC_SRV_A_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a() entered."));
   _poCallbackIf = OSAL_NULL;

   _tU8Echo_u8Data = 0;

   // timestampsync_tclServiceTimestampsync_srv_aConstructor: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: timestampsync_tclServiceTimestampsync_srv_a::
*             ~timestampsync_tclServiceTimestampsync_srv_a(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
timestampsync_tclServiceTimestampsync_srv_a::~timestampsync_tclServiceTimestampsync_srv_a(tVoid)
{
   ETG_TRACE_USR4(("~timestampsync_tclServiceTimestampsync_srv_a() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // timestampsync_tclServiceTimestampsync_srv_aDestructor: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'timestampsync_ServiceTimestampsync_srv_a.h':
*     Add forward declaration:
*         class Itimestampsync_tclObject2Get;
*
*     Add declaration of object reference:
*         Itimestampsync_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Itimestampsync_tclObject2Get*>(_cpoMain->getHandler("Itimestampsync_tclObject2Get"));
*     TIMESTAMPSYNC_SRV_A_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a::vGetReferences() entered."));
   // timestampsync_tclServiceTimestampsync_srv_avGetReferences: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a::vStartCommunication() entered."));
   // timestampsync_tclServiceTimestampsync_srv_avStartCommunication: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   timestampsync_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(timestampsync_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // timestampsync_tclServiceTimestampsync_srv_avHandleMessage: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vHandleTraceMessage(const tUChar* puchData)
{
   TIMESTAMPSYNC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // timestampsync_tclServiceTimestampsync_srv_avHandleTraceMessage: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      U8Echo (TIMESTAMPSYNC_MAINFI_C_U16_U8ECHO) -> Opcode: Get, Status, "));

   // timestampsync_tclServiceTimestampsync_srv_avTraceInfo: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // timestampsync_tclServiceTimestampsync_srv_avOnServiceAvailable: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_a::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_a::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // timestampsync_tclServiceTimestampsync_srv_avOnServiceUnavailable: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_avOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool timestampsync_tclServiceTimestampsync_srv_a
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool timestampsync_tclServiceTimestampsync_srv_a
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case TIMESTAMPSYNC_MAINFI_C_U16_U8ECHO:
      {
         timestampsync_mainfi_tclMsgU8EchoStatus oStatus;

         oStatus.u8Data = _tU8Echo_u8Data;

         // CaseU8EchoStatus_Pre: user specific code start
         // CaseU8EchoStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, TIMESTAMPSYNC_SRV_A_FI_MAJOR_VERSION);

         // CaseU8EchoStatus: user specific code start
         // CaseU8EchoStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool timestampsync_tclServiceTimestampsync_srv_a
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool timestampsync_tclServiceTimestampsync_srv_a
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_a:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid timestampsync_tclServiceTimestampsync_srv_a::sendU8EchoStatus(tU8 u8Data)
{

   _tU8Echo_u8Data = u8Data;


   ETG_TRACE_USR4(("sendU8EchoStatus() called."));
   eUpdateClients(TIMESTAMPSYNC_MAINFI_C_U16_U8ECHO);
}







// timestampsync_tclServiceTimestampsync_srv_atimestampsync_ServiceTimestampsync_srv_a: user specific code start
// timestampsync_tclServiceTimestampsync_srv_atimestampsync_ServiceTimestampsync_srv_a: user specific code end

//EOF
