#ifndef _ECHOINCPROXY_H_
#define _ECHOINCPROXY_H_

/*****************************************************************************
* FILE:         timestampsync_ClientEcho.h
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     incProxy.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

// Echo_incProxy_tclMainIncludes: user specific code start
// Echo_incProxy_tclMainIncludes: user specific code end

//include base class
#include "Itimestampsync_ClientEcho.h"
#include "timestampsync_ClientEchoIncFiDef.h"
#include "I_timestampsync_ClientEchoIncAdaptor.h"
#include "Echo_incCallbackIf.h"


class timestampsync_tclClientEcho : public I_timestampsync_tclClientEcho, public EchoIncCallbackIf
{
private: 
   I_timestampsync_tclClientEchoIncAdaptor*     _poThermalInc;
   tBool    _bAvailable;
public:
   timestampsync_tclClientEcho(timestampsync_tclAppMain* poMainAppl);
   virtual ~timestampsync_tclClientEcho();

   virtual const tChar* getName() const { return "timestampsync_tclClientEcho"; };
   
   virtual tVoid vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() {return _bAvailable;};

   // EchoIncCallbackIf interface
   virtual void onCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
   virtual void onECHO(tU8 EchoResponse, tU32 TimeStamp);

   // I_timestampsync_tclClientEcho interface (to send INC messages)
   virtual tBool sendCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus = ::echo_inc_fi::eACTIVE, tU8 ApplicationVersion = 1);
   virtual tBool sendECHO(tU8 EchoComment);
    // timestampsync_tclClientEchoAddClassPart: user specific code start
    // timestampsync_tclClientEchoAddClassPart: user specific code end
};

#endif // _VEDA_THERMAL_H_

