/************************************************************************
*FILE: 			 TTFisCmdHandler.cpp
*SW-COMPONENT:  HMI
*DESCRIPTION: 	 Defines the class TTFisCmdHandler which
*               handles TTFis input commands (that simulates Clients and NanoMsg Components actions)
*AUTHOR:        Supriya Seshadri(RBEI/ECG5)
*COPYRIGHT:     (c) 2018 - 2019 Robert Bosch Car Multimedia GmbH
*HISTORY:
*20.02.2020 Rev. 0.1 Supriya Seshadri
* 		    Initial Revision.
************************************************************************/

#ifndef NANOMSGTTFISHANDLERTTFIS
#define NANOMSGTTFISHANDLERTTFIS

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/* Macros to be defined for including the needed trace files */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

/*****************************************************************
| includes
|----------------------------------------------------------------*/

/* Header files required for Tracing out log statements */
#include "etrace_if.h"

/*****************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------*/

/*****************************************************************
| class declaration (scope: global)
|----------------------------------------------------------------*/

namespace NanoMsg_MasterApp{
	namespace NanoMsgServer{
		class TTFisCmdHandler; // Forward declaration

		/*****************************************************************
		| typedefs (scope: global)
		|----------------------------------------------------------------*/
		class TTFisCmdHandler
		{
		public:
			TTFisCmdHandler();
			~TTFisCmdHandler();

			static void initialize();

			//static void traceCmd_optionKeyRespCmd();
			static void traceCmd_RspGetPoweModeSignal(uint16_t tPowerMode, uint8_t devId, uint8_t devNr, tCString strIP);
			static void traceCmd_ReqSetChainModeRequest(uint8_t data1, uint8_t data2, uint8_t data3, uint8_t data4);
			static void traceCmd_ReqSetPowerMode(uint8_t DEVID, uint8_t DEVNO, uint16_t POWERMODE, tCString strIP);
			static void traceCmd_ReqGetPowerMode(uint8_t DEVID, uint8_t DEVNO, tCString strIP);
			static void traceCmd_ReqGetWakeupReason(uint8_t DEVID, uint8_t DEVNO, tCString strIP);
			static void traceCmd_ReqShutdown(uint8_t DEVID, uint8_t DEVNO, uint16_t TIMEOUT, tCString strIP);
                        static void traceCmd_ReqHealthCare(uint8_t DEVID, uint8_t DEVNO, tCString strIP);
			static void traceCmd_EventDigitalInput(uint8_t DEVID, uint8_t DEVNO, uint32_t DigitalInput, uint32_t Response,  tCString strIP);
			//static void traceCmd_IntercomEventPhone(uint8_t tPhoneNumber, uint8_t tPhoneStatus);
			static void traceCmd_EventIntercomCall(uint32_t tPhoneNumber,  tCString strIP);
                        static void traceCmd_EventPhoneStatusChange(uint8_t tPhoneNumber, uint8_t phone_Status, tCString strIP);
			static void traceCmd_ReqGetThermalState(uint8_t DEVID, uint8_t DEVNO, tCString strIP);
			static void traceCmd_ReqGetVoltageState(uint8_t DEVID, uint8_t DEVNO, uint16_t voltageval, tCString strIP);
                        static  void traceCmd_ReqGetIntercomAvailable(tCString strIP);
                        static void traceCmd_ReqCMGSvivelPosition(uint8_t DEVID, uint8_t DEVNO, tCString strIP);
			static void traceCmd_EventVoltage(uint8_t DEVID, uint8_t DEVNO, uint16_t VoltageLevel, uint16_t VoltageSensor, uint16_t VoltageValue, tCString strIP);
			static void traceCmd_EventThermalState(uint8_t DEVID, uint8_t DEVNO, uint16_t ThermalState, uint16_t ThermalSensorID, uint16_t Temperature, tCString strIP);
                        static void traceCmd_EventDtcOccurance(uint8_t DEVID, uint8_t DEVNO, tCString strIP);




		private:

			/* Assingment Operater, will not be implemented.
		  So if an attempt for the assignment is made compiler complains.
		  Copy constructor will also not be implemented */
			TTFisCmdHandler& operator= (
				const TTFisCmdHandler &corfoCmdHandler
				);
			TTFisCmdHandler(
				const TTFisCmdHandler &corfoCmdHandler
				);

		};
	}
}

#endif

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/

