/* ***************************************************************************************
* FILE:          clAsfLCMServiceAdaptor.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  clAsfLCMServiceAdaptor.cpp is part of NanoMsgMasterApp
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Supriya Seshadri
 * Date: 03.02.2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef NANOMSGMASTER_APP_H
#define NANOMSGMASTER_APP_H

#include "bosch/cm/di/NanoMsgLCMInterfaceStub.h"
#include "NanoMsgLCMInterfaceConst.h"
#include "NanoMsgLCMInterfaceStub.h"
#include "Constants.h"
#include "clMsgIDMapping.h"
#include <arpa/inet.h> 
#include "clSenderThread.h"

using namespace ::bosch::cm::di::NanoMsgLCMInterface;

namespace NanoMsg_MasterApp {
	namespace NanoMsgServer {
		class clAsfLCMServiceAdaptor :public IBackendInterface,
			public NanoMsgLCMInterfaceStub
		{
		public:
			virtual bool init();
			static clAsfLCMServiceAdaptor* getInstance();
			//todo : shoulnt be public
			static clAsfLCMServiceAdaptor *p_AsfLCMInstance;
			static void vDeleteInstance();

			virtual ~clAsfLCMServiceAdaptor();

			/*Will Handle Broadcast function for broadcast sig_RspSetPowerMode*/
			void sendLCMRspSetPowerModeSignal(stNanoMsgData *data);

			/*Will Handle Broadcast function for broadcast sig_RspGetPowerMode*/
			void sendLCMRspGetPowerModeSignal(stNanoMsgData *data);

			/*Will Handle Broadcast function for broadcast sig_EventPowerModeChange */
			void sendLCMEventPowerModeChange(stNanoMsgData *data);

			/*Will Handle Broadcast function for broadcast sig_RspGetWakeupReason */
			void sendLCMRspGetWakeupReason(stNanoMsgData *data);

			/*Will Handle Broadcast function for broadcast sig_RspShutdown */
			void sendLCMRspShutdown(stNanoMsgData *data);

			/*Will Handle Broadcast function for broadcast sig_RspSetChainMode */
			void sendRspSetChainMode(stNanoMsgData *data);
                       
                         /*Will Handle Broadcast function for broadcast sig_RspHealthCare*/
			void sendLCMRspHealthCareSignal(stNanoMsgData *data);

                      /*Will Handle Broadcast function for broadcast sig_EventDtcOccurance*/
			void sendLCMEventDtcOccuranceSignal(stNanoMsgData *data);

			/*The method onReqSetPowerMode() is called by ASF when a client invokes the method 'ReqSetPowerMode'*/
			void onReqSetPowerModeRequest(const ::boost::shared_ptr< ReqSetPowerModeRequest >& request);

			/*The method onReqGetPowerMode() is called by ASF when a client invokes the method 'ReqGetPowerMode'*/
			void onReqGetPowerModeRequest(const ::boost::shared_ptr< ReqGetPowerModeRequest >& request);

			/*The method onReqGetWakeupReason() is called by ASF when a client invokes the method 'ReqGetWakeupReason'*/
			void onReqGetWakeupReasonRequest(const ::boost::shared_ptr< ReqGetWakeupReasonRequest >& request);

			/* The method onReqShutdown() is called by ASF when a client invokes themethod 'ReqShutdown'.*/
			void onReqShutdownRequest(const ::boost::shared_ptr< ReqShutdownRequest >& request);

			void onReqSetChainModeRequest(const ::boost::shared_ptr< ReqSetChainModeRequest >& request);

                       /*The method onReqHealthCareRequest() is called by ASF when a client invokes the method 'ReqHealthCare'*/
			void onReqHealthCareRequest(const ::boost::shared_ptr< ReqHealthCareRequest >& request);
			
			
		private:
			clAsfLCMServiceAdaptor();
			clAsfLCMServiceAdaptor(const clAsfLCMServiceAdaptor&);           // Prevent copy-construction
			clAsfLCMServiceAdaptor& operator=(const clAsfLCMServiceAdaptor&);      // Prevent assignment
			clSenderThread *m_pcoreSenderThread;
		};
	}//Namespace NanoMsgServer
}

#endif // NANOMSGMASTER_APP_H

