/* ***************************************************************************************
* FILE:          clAsfGenericServiceAdaptor.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  clAsfGenericServiceAdaptor.h is part of NanoMsgMasterApp
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Supriya Seshadri
 * Date: 14.02.2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef NANOMSGMASTER_GENERICADAPTOR_H
#define NANOMSGMASTER_GENERICADAPTOR_H

#include "NanoMsgGenericInterfaceStub.h"
#include "NanoMsgGenericInterfaceConst.h"
#include "clMsgIDMapping.h"
//#include "clNanoMsgCoreThread.h"
#include "NanoMsgReceiver.h"
#include "clSenderThread.h"
#include <arpa/inet.h>

using namespace ::bosch::cm::di::NanoMsgGenericInterface;

namespace NanoMsg_MasterApp {
	namespace NanoMsgServer {
		class clAsfGenericServiceAdaptor : public IBackendInterface,  
							public NanoMsgGenericInterfaceStub
		{
		public:
			static clAsfGenericServiceAdaptor* getInstance();
			static void vDeleteInstance();

			virtual ~clAsfGenericServiceAdaptor();
			
			//Method Starts
			virtual void onReqGetDigitalInputRequest(const ::boost::shared_ptr< ReqGetDigitalInputRequest >& request);
			virtual void onReqGetDigitalInputCMPRequest (const ::boost::shared_ptr< ReqGetDigitalInputCMPRequest >& request);
			virtual void onReqGetDigitalInputCMGRequest (const ::boost::shared_ptr< ReqGetDigitalInputCMGRequest >& request);
			virtual void onReqGetThermalStateRequest (const ::boost::shared_ptr< ReqGetThermalStateRequest >& request);
			virtual void onReqGetVoltageRequest (const ::boost::shared_ptr< ReqGetVoltageRequest >& request);
                        virtual void onReqSetAnnouncementOutRequest (const ::boost::shared_ptr< ReqSetAnnouncementOutRequest >& request);
			virtual void onReqCMGSvivelPositionRequest(const ::boost::shared_ptr< ReqCMGSvivelPositionRequest >& request);
			
			//BroadCast Messages
			void sendGenericRspGetDigitalInput(stNanoMsgData *data);
			void sendGenericEventDigitalInput(stNanoMsgData *data);
			void sendGenericRspGetDigitalInputCMP(stNanoMsgData *data);
			void sendGenericEventDigitalInputCMP(stNanoMsgData *data);
			void sendGenericRspGetDigitalInputCMG(stNanoMsgData *data);
			void sendGenericEventDigitalInputCMG(stNanoMsgData *data);
			void sendGenericEventThermalSignal(stNanoMsgData *data);
			void sendGenericRspGetThermalSignal(stNanoMsgData *data);
			void sendGenericEventVoltageSignal(stNanoMsgData *data);
			void sendGenericRspGetVoltageSignal(stNanoMsgData *data);
                        void sendGenericRspSetAnnouncementOut(stNanoMsgData *data);
			void sendGenericRspCMGSvivelPositionSignal(stNanoMsgData *data);
            void sendGenericEventCMGSwivelPositionSignal(stNanoMsgData *data);
		private:
			clAsfGenericServiceAdaptor();
			static clAsfGenericServiceAdaptor *p_clAsfGenericServiceAdaptor;

			clAsfGenericServiceAdaptor(const clAsfGenericServiceAdaptor&);           // Prevent copy-construction
			clAsfGenericServiceAdaptor& operator=(const clAsfGenericServiceAdaptor&);      // Prevent assignment
			virtual bool init();
			clSenderThread *m_pcoreSenderThread;
		};
	}
}//Namespace NanoMsgServer

#endif // NANOMSGMASTER_GENERICADAPTOR_H
