/************************************************************************
* FILE:         protocoldefines.h
* PROJECT:      Inf4cv
* SW-COMPONENT: Messaging Framework for NanoMsg
*----------------------------------------------------------------------
*
* DESCRIPTION: Protocol related definitions
* NanoMsg protocol
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH
* HISTORY:
* Date      	| Author             		| Modification
* -----------------------------------------------------------------------------
* 09-02-2020   	Sunil Sagar(RBEI/ECG1)		Initial Version
* 27-03-2020   	Supriya Seshadri(RBEI/ECG5)	Added defines for the header length and payload length
*                                
*************************************************************************/
#ifndef NANOMSGFRAMEWORK_PROTOCOLDEFINE_PROTOCOLDEFINES_H_
#define NANOMSGFRAMEWORK_PROTOCOLDEFINE_PROTOCOLDEFINES_H_


#define INDEX_VERSION  0
#define INDEX_IP_BASE 0
#define INDEX_IP_BASE_ONE 1
#define INDEX_IP_BASE_TWO 2
#define INDEX_IP_BASE_THREE 3
#define INDEX_MAC 0
#define INDEX_LENGTH 5
#define INDEX_TYPE 6
#define INDEX_DATA  7

#define MAC_BYTE_LENGTH 6

#define INDEX_RAW_IP 2
#define INDEX_RAW_MAC 6
#define INDEX_RAW_LENGTH 14
#define INDEX_DEV_ID 12
#define INDEX_DEV_NUMBER 13
#define INDEX_RAW_MSGID 16
#define INDEX_RAW_DATA 18

#define DATA_SIZE_TWO_BYTE 2
#define DATA_SIZE_FOUR_BYTE 4

#define HEADER_SIZE 18

#define PROTOCOL_VERSION 6

#define DEV_ID_CMC 1
#define DEV_NUM_CMC 1

#define DATA_HEADER_LENGTH 4
#define MAX_PAYLOAD_LENGTH 1024//increased to handle DTC occurance event
#define DATA_HEADER_LENGTH_WITHPOWERMODE 6
#define CMC_HEADER_IP_FIRST_BYTE 192
#define CMC_HEADER_IP_SECOND_BYTE 168
#define CMC_HEADER_IP_THIRD_BYTE 0
#define CMC_HEADER_IP_FOURTH_BYTE 1

#endif /* NANOMSGFRAMEWORK_PROTOCOLDEFINE_PROTOCOLDEFINES_H_ */

