/* ***************************************************************************************
 * FILE:          NanoMsgProtocolSetup.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  NanoMsgProtocolSetup.h is part of NanoMsg_MasterApplication
 * 				 This is the protocol part of the application, has the nanomsg library interface implementation
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CMP_PROTO_NANOMSGSERVICE_NANOMSGPROTOCOLSETUP_H_
#define CMP_PROTO_NANOMSGSERVICE_NANOMSGPROTOCOLSETUP_H_

#include <nanomsg/nn.h>
#include "DataPacket.h"
#include "includes.h"

class clConnection
{
public:
    enum class Type { Connect, Bind };

    clConnection(int socket_id, std::string const& url, Type type);

    ~clConnection();
	
	bool getConnectionStatus(){return m_bconnectionStatus;}
	int socket_id;

private:
    clConnection(const clConnection&) = delete;
    clConnection& operator=(const clConnection&) = delete;

	bool m_bconnectionStatus;
    const int _connection_id;
};

class clSocket
{
public:
    clSocket(int type); //type is protocol to be used eg:NN_PUB, NN_PAIR, NN_REQ etc..


    ~clSocket();

    bool bind(const std::string& url);

    bool connect(const std::string& url);
	int setSocketOption();

    void disconnect();

    bool send(const tNanoDataPack message, int payloadsize, int &send_bytes); //Payload size = header + data size

    unsigned char * receive(int &recv_bytes);
	
	bool freeBuffer(unsigned char * buf);
	
	bool SendAck();
	
	int setSocketOptionReciever();
	int setSocketOptionSender();


private:
    clSocket(const clSocket&) = delete;
    clSocket& operator=(const clSocket&) = delete;
	int socket_id;

    std::unique_ptr<clConnection> connection;
};


#endif /* CMP_PROTO_NANOMSGSERVICE_NANOMSGPROTOCOLSETUP_H_ */
