/* ***************************************************************************************
 * FILE:          NanoMsgReceiver.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  NanoMsgReceiver.h is part of NanoMsg_MasterApplication
 * 				 This is the protocol part of the application, has the socket receiever implementation
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)   
 * REVISION: Supriya S 18.03.2020
 *		Added the extraction of IP URL in the recieve logic
 *		Added the Method Starts and the Broadcast messages with the functionality to provide to the clients
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */


#ifndef CLRECVNANOMSG_H_
#define CLRECVNANOMSG_H_

#include <chrono>
#include <future>
#include "includes.h"
#include "Constants.h"
#include "clReceiverThread.h"
#include "clSenderThread.h"
#include "NanoMsgProtocolSetup.h"
#include "protocoldefines.h"

class clRecvNanoMsg {
public:
	static clRecvNanoMsg* getInstance();
	static void vDeleteInstance();
	virtual ~clRecvNanoMsg();
	void vRecieveinLoop();
	bool SendAckForEventMessage(int MsgID);	

private:
	clRecvNanoMsg();
	static clRecvNanoMsg* m_poSelf;
	void processRecvMsg(unsigned char* buffer, int recv_bytes);
	clReceiverThread *m_pCoreReceiver;
	bool m_threadRunStatus; 
	
	void setThreadRunStatus(bool status){ m_threadRunStatus = status;}
	bool getThreadRunStatus() { return m_threadRunStatus; }
};


class clSocketthread
{
	public:
		//static clSocketthread* getInstance();
//		static void vDeleteInstance();
		static void* thStartFunction(void *arg);
		~clSocketthread();
		clSocketthread();
	private:
		
		//static clSocketthread* m_poSelf;
		pthread_t     m_thHandle;
	//	clRecvNanoMsg* p_instance;	
	
};

#endif /* CLRECVNANOMSG_H_ */
