/************************************************************************
* FILE:         DataPacket.h
* PROJECT:      Inf4cv
* SW-COMPONENT: Messaging Framework for NanoMsg
*----------------------------------------------------------------------
*
* DESCRIPTION: For packing and unpacking of nanomsg
* NanoMsg protocol
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH
* HISTORY:
* Date      	| Author             		| Modification
* -----------------------------------------------------------------------------
* 09-02-2020   	Shivakumar J(RBEI/ECH2)		Initial Version
* 27-03-2020   	Supriya S (RBEI/ECG5)		Rev. 0.1
*                                Initial Version
*************************************************************************/

#ifndef DATAPACKET_H_
#define DATAPACKET_H_

#include "Constants.h"
#include "protocoldefines.h"

#define IP_VERSION 4
#define MAC_ADDRESS_TYPE 6
#define DEFAULT_VAL 0
#define SIZE_OF_HEADER 18


//finally sent over TCP
//to be corrected
struct tHeader{
	uint16_t u16version;  //static
	uint8_t u8source_ip[IP_VERSION]; //static
	uint8_t u8source_mac[MAC_ADDRESS_TYPE]; //static
	uint8_t u8devId ; //static
	uint8_t u8devNumber ; //static
	uint16_t u16typeLength; //dynamic
	uint16_t u16msgId; //dynamic

	tHeader(){
		u16version = 0;
		memset(u8source_ip,0,IP_VERSION);
		memset(u8source_mac,0,MAC_ADDRESS_TYPE);
		u8devId = DEFAULT_VAL;
		u8devNumber = DEFAULT_VAL;		
		u16typeLength = 0;
		u16msgId = 0;
			
	}
};

struct tNanoDataPack{
	tHeader headerData; // static
	//non static to be only filled during sending
	uint8_t buffer[MAX_PAYLOAD_LENGTH]; //will contain the data
	tNanoDataPack(){
		for(int itr = 0; itr < MAX_PAYLOAD_LENGTH; itr++)
			buffer[itr] = 0;
	}
	

};

class clDataPacket
{
private:
	static void vSetSourceIp(struct tHeader &header);
	static void vSetSourceMac(struct tHeader &header);
	
	//No Creation of object allowed, this is just a helper class
	clDataPacket();
	clDataPacket(clDataPacket&);
	
public:
	static tNanoDataPack vCreateNanoPacket(tHeader& header, stNanoMsgData tdata);
	static void vPackURL(uint8_t URL[4], std::string& strURL);
	static void initCMCheader(tHeader& header);
};
#endif /* DATAPACKET_H_ */
