/* ***************************************************************************************
 * FILE:          clSenderThread.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clSenderThread.h is part of NanoMsg_MasterApplication
 * 				 This class is a thread class runs for sending msg to CIS
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLSENDERTHREAD_HEADER
#define CLSENDERTHREAD_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clNanoMsgCoreThread.h"
#include <iostream>
#include "NanoMsgSender.h"
//#endif

class clSenderThread : public clNanoMsgCoreThread
{

public:
	static clSenderThread* getInstance();
	static void vDeleteInstance();
	virtual ~clSenderThread();
	bool _nanoMsgCallBack(std::shared_ptr<stNanoMsgData> data);
private:
	clSenderThread();
	//bool readXML();
	static clSenderThread* m_poSelf;
	clNanoMsgSender* m_psender;
};
#endif // !defined(CLSENDERTHREAD_HEADER)
