/* ***************************************************************************************
 * FILE:          clSenderThread.cpp
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clSenderThread.cpp is part of NanoMsg_MasterApplication
 * 				 This class is a thread class runs for sending msg to CIS
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */


/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "clSenderThread.h"
#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_NANOMSGMASTERCMPCORE
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES6
#include "trcGenProj/Header/clSenderThread.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

clSenderThread* clSenderThread::m_poSelf = NULL;
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION:   Static Function, Singleton implementation, return the ptr of the
*				Singleton class clSenderThread
*PARAMETER:		None
*RETURNVALUE: 	clSenderThread*
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clSenderThread* clSenderThread::getInstance()
{
   if (NULL == m_poSelf)
   {
      m_poSelf = new clSenderThread();
   }
   return m_poSelf;
}
//todo Delete instance to be created
//delete instance to be called in the destructor of the NanoMsgMasterAppService

/************************************************************************
*FUNCTION: 		clSenderThread()
*DESCRIPTION:   Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clSenderThread::clSenderThread()
{
	//readXML();
	m_psender = new clNanoMsgSender();
}

/************************************************************************
*FUNCTION: 		~clSenderThread()
*DESCRIPTION:   Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clSenderThread::~clSenderThread()
{
	if(m_psender != NULL)
		delete m_psender;
}

/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION:   Static Function, Singleton implementation, Deletes the Singleton Object 
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG5)   Initial version
*************************************************************************/
void clSenderThread::vDeleteInstance()
{
   if (NULL != m_poSelf)
   {
	   ETG_TRACE_USR4(("clSenderThread::vDeleteInstance(), deleting the obj"));
		delete m_poSelf;
		m_poSelf = NULL;
   }
}


/************************************************************************
*FUNCTION: 		_nanoMsgCallBack()
*DESCRIPTION:   Thread call back function will be called by parent class 
*				when msg is added to queue to send it to entity
*PARAMETER:		std::shared_ptr<stNanoMsgData>
*RETURNVALUE: 	Bool
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
bool clSenderThread::_nanoMsgCallBack( std::shared_ptr<stNanoMsgData> data )
{
	bool callback = false;
	if(data != NULL)
	{
		ETG_TRACE_USR4(("clSenderThread::_nanoMsgCallBack MsgID=%d, and DevID=%d and datalength=%d",data->MsgID,data->DevID,data->DataLength));
		if(NULL != m_psender)
		callback = m_psender->sendDataToEntity(*(data.get()));
	}
	return callback;
} 
