/************************************************************************
* FILE:         constants.h
* PROJECT:      Inf4cv
* SW-COMPONENT: NanoMsg_Master
*----------------------------------------------------------------------
*
* DESCRIPTION: Protocol related Constants and definitions
* NanoMsg protocol
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH
* HISTORY:
* Date      	| Author             		| Modification
* -----------------------------------------------------------------------------
* 09-02-2020   	Shivakumar J(RBEI/ECH2)		Initial Version
* 27-03-2020   	Supriya Seshadri(RBEI/ECG5)	Added constructor for struct stNanoMsgData*                                
*************************************************************************/
#ifndef CONSTANTS_H_
#define CONSTANTS_H_

//typedef unsigned char BOOL;

//#define TRUE 1
//#define FALSE 0

typedef long LONG;
typedef void *VOIDPTR;

#define NANO_MSG_QUEUE_SIZE 100


//Will be used for maintaing the thread states

typedef enum {
	enmThStateBusy,
	enmThStateWaiting,
    enmThStateDown,
    enmThStateShuttingDown,
    enmThStateFault

} enum_ThreadSM_en;

//4 arguments use
//extend this struct to include the 32 bit data
//dev no

#include "protocoldefines.h"
#include "includes.h"

struct stNanoMsgData {

	uint8_t DevID;
	uint8_t DevNr;
	uint16_t MsgID;
	uint8_t data[MAX_PAYLOAD_LENGTH];
	uint16_t DataLength;
	std::string strURL;
	stNanoMsgData():DevID(0),DevNr(0),MsgID(0),DataLength(0),strURL("")
	{
		for (int itr = 0; itr < MAX_PAYLOAD_LENGTH; itr++) 
        data[itr] = 0;
	};
};



#endif /* CONSTANTS_H_ */
