/*
 * Copyright (c) 2010 Gracenote.
 *
 * This software may not be used in any way or distributed without
 * permission. All rights reserved.
 *
 * Some code herein may be covered by US and international patents.
 */

/*
 * gn_phonetic_conversion.h - 
 *
 * Is the backbone to the conversion process, both the X-SAMPA to L&H+
 * as well as the L&H+ post-processing conversion maps use this same 
 * algorithm.
 */

#ifndef _GN_PHONETIC_CONVERSION_H_
#define _GN_PHONETIC_CONVERSION_H_

#include "gn_phonetic_conversion_data.h"

#ifdef __cplusplus
extern "C"{
#endif

/*
 * Type Declarations
 */

/*
 * API Declarations
 */

/* gn_phonetic_conversion_map_convert
 *
 * Convert phoneme string with Phonetic Conversion Map.
 *
 * Memory is allocated by this call. The gnepal_mem_free function should
 * be called once the destination string is no longer needed.
 *
 * Parameters:
 *  IN		: conversion_map	: An initialized Phonetic Conversion Map object.
 *  IN		: src				: Phoneme source string.
 *  OUT		: dst				: Phoneme destination string.
 *
 * Return Values:
 *  On success:
 *   error						: GNEX_PHOCVRT_NoError
 *   dst						: Dynamically allocated and converted phoneme destination string.
 *
 *  On error:
 *   error						: Gracenote Extension Error Value
 *   dst						: Will not have been modified.
 *
 *  Errors include:
 *   GNEX_PHOCVRT_NoMemory		: memory allocation
 *   GNEX_PHOCVRT_InvalidArg	: invalid argument
 */
gnex_error_t
gn_phonetic_conversion_map_convert(
	const gn_phonetic_conversion_map_t* conversion_map,
	const gn_uchar_t* src,
	gn_uchar_t** dst
	);

#ifdef __cplusplus
};
#endif


#endif
