/// \file GracenoteWrapperInterface.h
///
/// Header file for Gracenote integration library interface
///
/// Copryright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
#ifndef GRACENOTEWRAPPERINTERFACE_H_
#define GRACENOTEWRAPPERINTERFACE_H_
#ifdef LOCAL_COMPILE_INGO
#include "system_types.h"
#endif
#include <time.h>
#include "GracenoteLanguageId.h"

// Forward declaration to use PIMPL-interface
class tclGracenoteWrapper;

/// \brief API to access the TextID/MediaVOCS API from Gracenote
///
/// \author Ingo Reise CM-AI/PJ-GM28
class tclGracenoteWrapperInterface
{
public:
   /// Fixed maximum length of returned phonemes
   /// Meta-data for songs is stored with max 90 (UTF8-)chars in the
   /// MyMedia database. Phonemes are usually 2-3bytes long. 
   /// The GN-database currently contains phonemes up to ~230 bytes
   /// Thus 250bytes seems to be a useful upper limit, longer phonemes are cut
   static const tInt MAX_PHONEME_LENGTH = 250;

   /// specify query type
   enum QueryType {
      ALBUM,     /*!< query for an album title */
      ARTIST,    /*!< query for the main contributor of an album */
      GENRE    /*!< query for a music genre */
   };

   // Start/initialize GN database access
   tBool start(void);

   // Stop GN database access
   void stop(void);

   // Query GN database for speech recognition
   tInt srQuery(QueryType type,
                tclLanguageId qlang,
                tString qstring,
                tUInt maxHits,
                tString phonemes[]);

   // Query GN database for text to speech
   tInt ttsQuery(QueryType type,
                 tclLanguageId qlang,
                 tString qstring,
                 tString phoneme);

   // Get timestamp of latest update
   tLong getUpdateTime(void);

   tLong getSnapshotTime(void);


   // Default Constructor
   tclGracenoteWrapperInterface();

   // Destructor
   ~tclGracenoteWrapperInterface();

   // Copy Constructor
   tclGracenoteWrapperInterface(const tclGracenoteWrapperInterface &);

   // Assignment operator
   tclGracenoteWrapperInterface& operator=(tclGracenoteWrapperInterface);


private:
   tclGracenoteWrapper* pImpl;
};

#endif /*GRACENOTEWRAPPERINTERFACE_H_*/
