/// \file GracenoteLanguageCode.h
///
/// Header for base class to handle numeric (short) representations of ISO language codes
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
/// \version 13.06.2016 Upgraded ISO 639-1 two letter to ISO 639-2/639-3 three letter codes (based on GM changes from 30.03.2015)
///
#ifndef GRACENOTELANGUAGECODE_H_
#define GRACENOTELANGUAGECODE_H_

#include "GracenoteIsoCodeAsShort.h"

#define SDS_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "sds_fi_gen_if.h"


/// Language code for handling languages according to 3-char language code (ISO 639-2/639-3)
class tclLanguageCode : public IsoCodeAsShort
{
private:
    void setCode(char* const lc);
public:
    /*! \cond ALL */
    // Constructor just setting code directly
    tclLanguageCode(short lc);

    // Constructor converting three characters to 16 bit short
    tclLanguageCode(char *lc);
    /*! \endcond */

    // Constructor with sds_fi_tcl_e16_ISOLanguageCode
   tclLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode lc);
};

#endif /*GRACENOTELANGUAGECODE_H_*/
