/// \file GracenoteIsoCodeAsShort.h
///
/// This provides base class to handle numeric (short) representations of ISO codes
/// for languages and countries
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
///
#ifndef GRACENOTEISOCODEASSHORT_H_
#define GRACENOTEISOCODEASSHORT_H_

/*! \cond ALL */

/// Base class to handle numeric (short) representations of ISO codes
/// for languages and countries
class IsoCodeAsShort  {
protected:
    // 16 bit representation of ISO code
    short code;
public:
    // default constructor
    IsoCodeAsShort();
    
    // cast to short
    operator short const() const;

    // less operator
    bool operator<(const IsoCodeAsShort &icas2) const;

    // equality operator
    bool operator==(const IsoCodeAsShort &icas2) const;
};
/*! \endcond */

#endif /*GRACENOTEISOCODEASSHORT_H_*/
