/// \file GracenoteCountryCode.h
///
/// Header for base class to handle numeric (short) representations of ISO country codes
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
///
#ifndef GRACENOTECOUNTRYCODE_H_
#define GRACENOTECOUNTRYCODE_H_
#include "GracenoteIsoCodeAsShort.h"

// #define __PLACEMENT_NEW_INLINE
#define SDS_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "sds_fi_gen_if.h"


/// Language code for handling countreis according to ISO 3166-1 (three upper characters)
class tclCountryCode : public IsoCodeAsShort
{
private:
    // Convert three characters to 15 bit short, 5bit per character
    void setCode(char* const lc);

public:
    /*! \cond ALL */
    // Constructor just setting code directly
    tclCountryCode(short lc);

    // Constructor converting three characters to 15 bit short
    tclCountryCode(char *lc);
    /*! \endcond */

    //
    tclCountryCode(sds_fi_tcl_e16_ISOCountryCode cc);
};



#endif /*GRACENOTECOUNTRYCODE_H_*/
