/* ***************************************************************************************
* FILE:          HealthCareMonServer.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  HealthCareMonServer.h is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 14.06.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HEALTHCARE_MON_SERVER_H
#define HEALTHCARE_MON_SERVER_H

#include "HealthcareMonServiceStub.h"
#include "HealthcareMonServiceConst.h"
#include "HealthcareMonDtcProcess.h"

using namespace ::bosch::cm::ai::HealthcareMonService;

class HealthCareMonServer : public HealthcareMonServiceStub
{

public:
	 static HealthCareMonServer* getInstance();
         static void vDeleteInstance();
	 virtual ~HealthCareMonServer();

	 virtual void onSendAcknowldgementRequest (const ::boost::shared_ptr< SendAcknowldgementRequest >& request);
         void toTestServer(uint8_t choice);
         void vSendToHMI(::bosch::cm::ai::HealthcareMonService::enDevID dev_ID,uint8 dev_Nr,uint32 dtcCode,uint16 text_ID,std::string default_text);
	
private:
	HealthCareMonServer();
	static HealthCareMonServer* p_HealthCareMonServer;

	HealthCareMonServer(const HealthCareMonServer&);           // Prevent copy-construction
	HealthCareMonServer& operator=(const HealthCareMonServer&);      // Prevent assignment
};
#endif
