/* ***************************************************************************************
* FILE:          HealthCareMonServer.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  HealthCareNanoMsgClient.h is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 16.06.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HEALTHCARE_MON_CLIENT_H
#define HEALTHCARE_MON_CLIENT_H

#include "NanoMsgLCMInterfaceProxy.h"
#include "NanoMsgLCMInterfaceClientBase.h"
#include "NanoMsgLCMInterfaceConst.h"
#include "HealthcareDefines.h"
#include "../DTCProcess/HealthcareMonDtcProcess.h"

using namespace ::asf::core;
using namespace ::bosch::cm::di::NanoMsgLCMInterface;

class HealthCareNanoMsgClient : public ::asf::core::ServiceAvailableIF
	                        ,Sig_RspHealthCareCallbackIF
			        ,Sig_EventDtcOccuranceCallbackIF
{
private :
	static HealthCareNanoMsgClient* p_HealthCareNanoMsgClient;
public:

	virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
	virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

	 virtual void onSig_RspHealthCareSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareSignal >& signal);
	 virtual void onSig_RspHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareError >& error);

         virtual void onSig_EventDtcOccuranceError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceError >& error);

         virtual void onSig_EventDtcOccuranceSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceSignal >& signal);
	 void totestDtcEvent(int i);

	 static HealthCareNanoMsgClient* getInstance();
     static void vDeleteInstance();
	 virtual ~HealthCareNanoMsgClient();
         HealthCareNanoMsgClient();
	 HealthCareNanoMsgClient(const HealthCareNanoMsgClient&);           // Prevent copy-construction
	 HealthCareNanoMsgClient& operator=(const HealthCareNanoMsgClient&);      // Prevent assignment
	 ::boost::shared_ptr< NanoMsgLCMInterfaceProxy > m_poLCMDBUSProxy;
};
#endif
