/* ***************************************************************************************
* FILE:          HealthCareDiaglogClientHandler.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  HealthCareDiaglogClientHandler.h is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 21.09.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HEALTHCARE_MON_DIAGLOG_CLIENT_H
#define HEALTHCARE_MON_DIAGLOG_CLIENT_H


#define ETHERNETSTATUSTIMER 1000

#include "diaglog_main_fiProxy.h"
#include "diaglog_main_fiClientBase.h"
#include "diaglog_main_fi_types.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include <fstream>
#include "HealthcareDefines.h"
#include  "midw_fi_if.h"
#include "vd_diaglog_itc_definition.h"

#define SETITC 1
#define DONTSETITC 2



using namespace ::asf::core;
using namespace ::diaglog_main_fi;
using namespace ::diaglog_main_fi_types;



class HealthCareDiaglogClient : public ::asf::core::ServiceAvailableIF,::diaglog_main_fi::SaveTestResultCallbackIF,::asf::core::TimerCallbackIF
{
	private :
		static HealthCareDiaglogClient* p_HealthCareDiaglogClient; 
    public :
		virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
            virtual void onSaveTestResultError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultError >& error);

    virtual void onSaveTestResultResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultResult >& result);

	    virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
	      virtual void onExpired(asf::core::Timer & timer, boost::shared_ptr <asf::core::TimerPayload> payload);
		static HealthCareDiaglogClient* getInstance();
		void readfile();
		void SetItc(uint32_t u32_dtccode,T_e8_TestResult status);
        static void vDeleteInstance();
	    virtual ~HealthCareDiaglogClient();
	    void InitializeTimerCallbacks();
	    void checkGPIOState_MCP();
	    void checkItcStateforMCP(bool bMcpValue,bool bMcpDiagValue);
		HealthCareDiaglogClient();
		HealthCareDiaglogClient(const HealthCareDiaglogClient&);           // Prevent copy-construction
	    HealthCareDiaglogClient& operator=(const HealthCareDiaglogClient&);      // Prevent assignment}
	    ::boost::shared_ptr< Diaglog_main_fiProxy > m_poDiaglogProxy;
	    uint32_t u32_EthernetTimer;
	    Timer  ethernettimerObj;
	   typedef void (HealthCareDiaglogClient::*funcptr)();
	    struct DtCconfig
             {
                funcptr timerfuncptr;
                uint8_t u8_timeinterval;
                uint32_t u32_dtcCode;

	     };
          const  DtCconfig dtconf[3] = {{&HealthCareDiaglogClient::readfile,5,ITC_CMC_ETHERNET_NO_COMMUNICATION},
		                        {&HealthCareDiaglogClient::checkGPIOState_MCP,5,ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_BATTERY},
		                        {&HealthCareDiaglogClient::checkGPIOState_MCP,5,ITC_CMC_SWITCHABLE_OUTPUT_VOLTAGE_SHORT_TO_GROUND}};
	    struct TimerCallbackMapping
            {
		funcptr timerfuncptr;
		uint8_t u8_timeinterval;
		uint32_t u32_dtcCode;
		uint8_t u8_dTCStatus;
		uint8_t u8SetItcFlag;
		
	    };
            funcptr executeptr;
             uint64_t u64counter;
            vector<TimerCallbackMapping> m_callbackinfo;
	    vector<TimerCallbackMapping>::iterator timercallbackitr;
	    FILE* pFile;

};
#endif

