/************************************************************************
*FILE: 			 EmpListTTFisCmd.h
*SW-COMPONENT:  Di_Middleware_server
*DESCRIPTION: 	 Defines the class EmpListTTFisCmd which
*               handles TTFis input commands (that simulates Clients and EMPList Components actions)
*AUTHOR:        DRM2KOR
*COPYRIGHT:     (c) 2018 - 2019 Robert Bosch Car Multimedia GmbH
*HISTORY:
*20.02.2020 Rev. 0.1 DRM2KOR
* 		    Initial Revision.
************************************************************************/

#ifndef EMPLISTTTFISCMD
#define EMPLISTTTFISCMD


/* Macros to be defined for including the needed trace files */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON

/*****************************************************************
| includes
|----------------------------------------------------------------*/

/* Header files required for Tracing out log statements */
#include "etrace_if.h"
#include "../DBManager/inc/DAO/SelectQueryDAO.h"
#include "../../../../di_trace/components/etg/etg.h"

namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {
		
		class EmpListTTFisCmd
		{
		public:
			EmpListTTFisCmd();
			~EmpListTTFisCmd();

			static void initialize();
                        static void traceCmd_getDbStates(uint16_t SRCTYPE);
                        static void traceCmd_getSelectedLanguages(uint16_t SRCTYPE);
                        static void traceCmd_SetLanguages( uint16_t SRCTYPE);
                        static void traceCmd_SetPlayBackModes(uint32_t PLAYMODE, uint16_t SRCTYPE, uint16_t REGION, uint32_t SUBSOURCE);
                        static void traceCmd_RequestTrackIndex(uint8_t TRACKINDEXACTION, uint16_t SRCTYPE, uint16_t LISTTYPE, std::string FOLDERPATH);
                        static void traceCmd_GetPlayBackMode(uint16_t SRCTYPE);
                        static void traceCmd_AADownloadRequest(uint16_t SRCTYPE, uint16_t SONGID, uint16_t LISTTYPE);
                        static void traceCmd_CreateMediaPlayerListRequest(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t AbsoluteIndex);
                        static void traceCmd_MediaPlayerListSliceRequest(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t StartingIndex,uint8_t WindowSize);
						static void traceCmd_HasPlayableAudioVideoFiles ( uint16_t SRCTYPE ); 
						static void traceCmd_CheckInit_Playable ( uint16_t SRCTYPE); 
						static void traceCmd_GetFirstSongId ( uint16_t LISTTYPE, uint16_t SRCTYPE );
						static void traceCmd_GetListCount ( uint16_t SRCTYPE , uint16_t LISTTYPE );
                        static void traceCmd_GetListSlice ( uint16_t SRCTYPE , uint16_t LISTTYPE, uint16_t STARTINDEX );
                        static void traceCmd_GetlastSong ( uint16_t LISTTYPE, uint16_t SRCTYPE );
                        static void traceCmd_GetListInfo ( uint16_t SRCTYPE , uint16_t LISTTYPE );
                        static void traceCmd_DeInit ( uint16_t SRCTYPE );
                        static void traceCmd_Init ( uint16_t SRCTYPE );
						static void traceCmd_GetNextPreviousSongId ( uint16_t SRCTYPE , uint16_t LISTTYPE, uint16_t SONGID , uint16_t Direction, uint16_t filetype);
                  
			
		private:

			/* Assingment Operater, will not be implemented.
		  So if an attempt for the assignment is made compiler complains.
		  Copy constructor will also not be implemented */
			EmpListTTFisCmd& operator= (
				const EmpListTTFisCmd &corfoEmpListTTFisCmd
				);
			EmpListTTFisCmd(
				const EmpListTTFisCmd &corfoEmpListTTFisCmd
				);

		};
	}
}
}

#endif

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
