/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : TFTPClientCMR.h
* COMPONENT Name      : di_middlewareserver
* DESCRIPTION         : Handles downloading of DB or Albumart for external media player List
* AUTHOR              : Madhuree
* Date                : 31.08.2020
* Revision History    : 0.1
* Date 31.08.2020     : Initial version
****************************************************************************/

#ifndef TFTPCLIENTCMR_HEADER
#define TFTPCLIENTCMR_HEADER

#include <stdio.h>
#include <string>
#include "AVRoutingParser.h"
#include "../DbusComponent/AvdeccClient/AvdeccPluginConstant.h"
#include "TFTPClientBase.h"
#include "TFTPClientDefines.h"

class TFTPClientCMR: public TFTPClientBase
{
    public:
        TFTPClientCMR();
        virtual ~TFTPClientCMR();
        static size_t my_fwrite(void *buffer, size_t size, size_t nmemb, void *stream);
        EnumConst::entDownloadState reqDBDownload(uint16_t sourceType);
        EnumConst::entDownloadState reqAlbumArtDownload(uint16_t sourceType, uint16_t songId, uint16_t FileType);
        void RemoveDBFile(uint16_t sourceType);
        std::string getCmrIpAddress();
        
    private:
        static TFTPClientCMR* m_poSelf;
        bool downloadDB(std::string IP);
        bool downloadAlbumart(std::string IP, uint16_t songID, uint16_t listType);
        bool curlDownloadFile(TftpFile *tftpFile, std::string url);
        void removePrevAlbumart();	
         std::string CmrIpAddress = "";
        void createDirectory();	
        bool initializeXMLParser ();		

};


#endif
