/* ***************************************************************************************
 * FILE:          clCMRProcessThread.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  clCMRProcessThread.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLCMRPROCESSTHREAD_HEADER
#define CLCMRPROCESSTHREAD_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clListHandlerCoreThread.h"
#include "ListHandlerLogic.h"
#include <iostream>

//#endif

class clCMRProcessThread : public clListHandlerCoreThread
{

public:
	static clCMRProcessThread* getInstance();
	static void vDeleteInstance();
	virtual ~clCMRProcessThread();
	bool _listRequestCallBack(std::shared_ptr<stWindowSliceRequest> listData);
private:
	clCMRProcessThread();
	static clCMRProcessThread* m_poSelf;
		
};
#endif // !defined(CLCMRPROCESSTHREAD_HEADER)
