/* ***************************************************************************************
 * FILE:          clCMPProcessThread.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  clCMPProcessThread.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLCMPPROCESSTHREAD_HEADER
#define CLCMPPROCESSTHREAD_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clListHandlerCoreThread.h"
#include "ListHandlerLogic.h"
#include <iostream>

//#endif

class clCMPProcessThread : public clListHandlerCoreThread
{

public:
	static clCMPProcessThread* getInstance();
	static void vDeleteInstance();
	virtual ~clCMPProcessThread();
	bool _listRequestCallBack(std::shared_ptr<stWindowSliceRequest> listData);
private:
	clCMPProcessThread();
	static clCMPProcessThread* m_poSelf;
		
};
#endif // !defined(CLCMPPROCESSTHREAD_HEADER)
