/************************************************************************
*FILE: 			ListHandlerLogic.h
*SW-COMPONENT:
*DESCRIPTION:   This is list handler used to provide mediaplayer list data slices to HMI
*AUTHOR: 		Deepak Babu K
*COPYRIGHT: 	(c) 2020 - 2021 Robert Bosch Car Multimedia GmbH
*HISTORY:
*06.10.2020 Rev. 0.2 Deepak Babu K
*			bRequestDBDownload interface added 
*28.07.2020 Rev. 0.1 Deepak Babu K
* 			Initial Revision.
************************************************************************/
#ifndef EMP_LISTHANDLER_LOGIC_HEADER
#define EMP_LISTHANDLER_LOGIC_HEADER

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "ListHandlerTypes.h"
#include "ListHandler.h"
#include "dbManagerTypeDefs.h"
#include <map>

#ifdef EMPLISTHANDLER_UNIT_TEST
#include "gtest/gtest_prod.h"
#endif

using namespace listHandlerTypes;

class tclListHandlerLogic
{
public:
	
	~tclListHandlerLogic();
	
	 virtual void vRequestCreateMediaPlayerList(const EnumConst::entListType eListType,
										const EnumConst::entSourceType eSourceType,
										const uint8_t u8Region,
										std::string sFolderPath
										);
	 void vUpdateMediaPlayerListCount(const EnumConst::entListType eListType);

	 virtual void vRequestMediaPlayerListSlice(stWindowSliceRequest listData);

	// this function will be used by client for getting the itemList
	 void vUpdateMediaPlayerListSlice(dbManagerTypes::ItemList vSliceList, const EnumConst::entSourceType eSourceType, EnumConst::entListType enListType);
     void vHandleClearListData(const EnumConst::entListType eListType,	const EnumConst::entSourceType eSourceType,const uint8_t u8Region);
	 void vHandleClearListData();

	//TODO : Mediaplayback functions to be implemented
    void vRequestTrackIndex(uint8_t u8TrackIndexAction, uint16_t srcType, \
                            EnumConst::entListType enListType, std::string sFolderPath, uint8_t u8_Region );
	void vCurrentTrackIndexUpdate(uint16_t u16CurrentTrackIndex, EnumConst::entFileType enFileType);
	void vCurrentListTypeUpdate(EnumConst::entListType enCurrListType);
    void vSendNextPrevTrackIndex(uint8_t u8TrackIndexAction, uint16_t srcType, EnumConst::entListType enListType);
	void vSendFirstTrackIndex(uint16_t srcType);
	void vUpdateTrackIndex(bool isAvailable , ResponseSongInfo songInfo, uint16_t srcType, EnumConst::entListType enListType);
    EnumConst::entListType enGetCurrentListType();
    uint8_t u8GetRegion();
    void vSetRegion(uint8_t u8_Region);
    bool vCreateShuffleList(EnumConst::entListType enCurrListType, uint16_t SrcType);
    bool bGetNextPreviousTrackIndexFromShuffledList(uint8_t u8TrackIndexAction, uint16_t m_u16CurrTrackIndex, ResponseSongInfo &sNewTrackInfo);
    void vClearShuffleList();
    void vFetchFirstAndLastTrackIndex(uint16_t SrcType);
    void vClearFirstAndLastTrackIndex();
    EnumConst::enSubSourceType enDeduceCurrentSubSourceType(EnumConst::entSourceType srcType);

    uint16_t getListCount();

protected :
	
	
	//Constructor as protect to avoid unwanted instance creation
	tclListHandlerLogic();

	EnumConst::entSourceType m_enRequestedListSourceType;
	uint8_t m_u8RequestedListRegion;
	EnumConst::entListType m_enRequestedListType;
	listHandlerTypes::mEMPDataMap m_EMPList;
	uint16_t m_u16count;
	uint16_t m_u16CurrTrackIndex;
    EnumConst::entFileType m_enCurrentTrackFileType;
    std::string m_sFolderPath;
    uint8_t m_u8Region;
	EnumConst::entListType m_enCurrListType;
    dbManagerTypes::ItemList  m_Curr_List;
    uint32_t  m_u32RepeatListLastTrackindex;
    uint32_t  m_u32RepeatListFirstTrackindex;
    EnumConst::entFileType m_u32RepeatListLastTrackindexFileType;
    EnumConst::entFileType m_u32RepeatListFirstTrackindexFileType;
	/* Assingment Operater, will not be implemented.
	 So if an attempt for the assignment is made compiler complains.*/
	
	tclListHandlerLogic& operator=(const tclListHandlerLogic&) = delete;
								
	/*Copy constructor will also not be implemented */
	tclListHandlerLogic(const tclListHandlerLogic &corfoLogic);

	void vGetListCount(EnumConst::entListType, EnumConst::entSourceType srcType, std::string sFolderPath);
	bool vCreateListhandlerInstance(const EnumConst::entListType);
	void vUpdateListCount(const uint16_t u16count,const EnumConst::entListType eListType);
    void vclearMap();
    
    #ifdef EMPLISTHANDLER_UNIT_TEST
    //friend class clCMPListHandlerLogicTest;
  
		FRIEND_TEST(clCMPListHandlerLogicTest, vHandleClearListDataTest);
		FRIEND_TEST(clCMRListHandlerLogicTest, vHandleClearListDataTest);

    #endif

};

#endif // end of  EMP_LISTHANDLER_LOGIC_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
