/************************************************************************
*FILE: 			ListHandler.h
*SW-COMPONENT:
*DESCRIPTION:   This is list handler used to keep  list and its opetations
*AUTHOR: 		Deepak Babu K
*COPYRIGHT: 	(c) 2020 - 2021 Robert Bosch Car Multimedia GmbH
*HISTORY:
*23.12.2020 Rev. 0.2 Shraddha S K
*16.09.2020 Rev. 0.1 Deepak Babu K
* 				Initial Revision.
************************************************************************/
#ifndef EMP_LISTHANDLER__HEADER
#define EMP_LISTHANDLER__HEADER

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "ListHandlerLogic.h"
#include "dbManagerTypeDefs.h"

#ifdef EMPLISTHANDLER_UNIT_TEST
#include "gtest/gtest_prod.h"
#endif

class tclListHandlerInterface
{
public:
	
	tclListHandlerInterface(EnumConst::entListType eListType);
	~tclListHandlerInterface();
	inline void vSetTotalListSize(const uint16_t u16ListSize){m_u16TotalListSize = u16ListSize;};
	inline void vSetListType(const EnumConst::entListType eListType){m_eListType = eListType;};
	inline const  uint16_t u16GetTotalListSize(){return m_u16TotalListSize ;}
	inline const EnumConst::entListType eGetListType() {return m_eListType;}
    dbManagerTypes::ItemList vReqListSlice(uint16_t u16StartIndex,uint16_t u8WindowSize, EnumConst::entSourceType SrcType, std::string sFolderpath);
	void vRequestListBuffer(uint16_t u16StartIndex, uint16_t u8WindowSize, \
                EnumConst::entSourceType SrcType, dbManagerTypes::ItemList& ListData, std::string sFolderpath);
	uint16_t u16GetRelativeStart();
	void vGetWindowIndexSent();
	void vClearListData();
private:
    tclListHandlerInterface(){}
	uint8_t m_u8WindowSize;
	uint16_t m_u16TotalListSize;
	uint16_t m_u16CurrStartIndex;
	uint16_t m_u16PrevStartIndex;
	uint16_t m_u16WindowIndex;
	uint16_t m_u16WindowIndexSent;
	EnumConst::entListType m_eListType;
	dbManagerTypes::ItemList  m_Curr_Data;
	dbManagerTypes::ItemList  m_Prev_Data;
	dbManagerTypes::ItemList  m_Next_Data;
    
    #ifdef EMPLISTHANDLER_UNIT_TEST
  //friend class clCMPListHandlerLogicTest;
  
		FRIEND_TEST(clCMPListHandlerLogicTest, vRequestListBufferTest);
		FRIEND_TEST(clCMRListHandlerLogicTest, vRequestListBufferTest);
        

 #endif

};
#endif // end of  EMP_LISTHANDLER_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
