/* ***************************************************************************************
 * FILE:          CMRListHandlerLogic.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  CMRListHandlerLogic.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLCMRLISTHANDLERLOGIC_HEADER
#define CLCMRLISTHANDLERLOGIC_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

#include "ListHandlerLogic.h"
#include "dbManagerTypeDefs.h"

class CMRListHandlerLogic : public tclListHandlerLogic
{

public:
	static CMRListHandlerLogic* getInstance();
	static void vDeleteInstance();
	virtual ~CMRListHandlerLogic();
	virtual void vRequestMediaPlayerListSlice(stWindowSliceRequest listData);
	virtual void vRequestCreateMediaPlayerList(const EnumConst::entListType eListType,
													const EnumConst::entSourceType eSourceType,
													const uint8_t u8Region,
													std::string sFolderPath);
    virtual void vUpdateListSlice(dbManagerTypes::ItemList& , EnumConst::entListType enListType);
    CMRListHandlerLogic();
private:	
	static CMRListHandlerLogic* m_poSelf;
		
};
#endif //CLCMRLISTHANDLERLOGIC_HEADER
