///////////////////////////////////////////////////////////
//  tClAlbumArt.cpp
//  Implementation of the Class tClAlbumArt
//  Created on:      01-Jul-2020 3:46:39 PM
//  Original author: VTA5KOR
///////////////////////////////////////////////////////////
#include "tClAlbumArt.h"
#include "TFTPClientBase.h"

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_ALBUMART
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/tClAlbumArt.cpp.trc.h"
#endif
tClAlbumArt* tClAlbumArt::m_poSelfAlbumArt = NULL;

/************************************************************************
*FUNCTION: 		tClAlbumArt()
*DESCRIPTION: 	Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
tClAlbumArt::tClAlbumArt()
{
	 ETG_TRACE_USR4(("tClAlbumArt Constructor"));
	 m_u8AlbumArtDLState = IDLE;
	 m_u16SourceType = 0;
	 m_u16CurrentTrackIndex = 0;
	 m_u16CurrentSongFileType = 0;
	 m_u16PrevTrackIndex = 0;
	 m_u8TFTPAlbumArtDLStatus = entDownloadState_DownloadError;
	 m_poHmiServiceAdaptor = EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor::getInstance();
     m_poEmpFactory = EMPFactory::getEmpFactoryReference();

}

/************************************************************************
*FUNCTION:      poGetInstance()
*DESCRIPTION:   
*PARAMETER:	None
*RETURNVALUE: 	tClAlbumArt*
*HISTORY:
*revision 0.1	
*************************************************************************/
tClAlbumArt* tClAlbumArt::poGetInstance()
{
    ETG_TRACE_USR4(("tClAlbumArt::poGetInstance()"));
   /* No more than one instance of tClAlbumArt should be created */
   if (NULL == m_poSelfAlbumArt)
   {
      m_poSelfAlbumArt = new tClAlbumArt();
   }
   return m_poSelfAlbumArt;
}
	
/************************************************************************
*FUNCTION: 		~tClAlbumArt()
*DESCRIPTION: 	Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
tClAlbumArt::~tClAlbumArt()
{
   if (NULL != m_poSelfAlbumArt)
   {
      delete m_poSelfAlbumArt;
      m_poSelfAlbumArt = NULL;
   }
}


/************************************************************************
*FUNCTION: 		vSetTrackDetails()
*DESCRIPTION: 	List handler to provide the SourceType and TrackIndex details.
*PARAMETER:		SourceType, TrackIndex, FileType
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void tClAlbumArt::vSetTrackDetails(uint16_t sourceType, uint16_t TrackIndex, uint16_t FileType)
{  
   ETG_TRACE_USR4(("tClAlbumArt vSetTrackDetails sourceType %d TrackIndex %d",sourceType,TrackIndex));
   m_u16SourceType = sourceType;
   m_u16CurrentTrackIndex = TrackIndex;
   m_u16CurrentSongFileType = FileType;
   vHandleAADownloadState();
}

/************************************************************************
*FUNCTION: 		vFetchAlbumArt()
*DESCRIPTION: 	FetchAlbumArt will request TFTP client to Download AA.
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void tClAlbumArt::vFetchAlbumArt(uint16_t sourceType , uint16_t TrackIndex)
{
    EnumConst::entDownloadState albumartDownloadStatus = EnumConst::entDownloadState_Default;
	if(m_poEmpFactory != NULL)
	{
	   ETG_TRACE_USR4(("tClAlbumArt vFetchAlbumArt sourceType %d TrackIndex %d FileType %d",sourceType,TrackIndex,m_u16CurrentSongFileType));
       TFTPClientBase* poTftpClient = (m_poEmpFactory->getTFTPClientreference(static_cast< EnumConst::entSourceType >(sourceType)));
       if(poTftpClient != NULL)
       {
           albumartDownloadStatus = poTftpClient->reqAlbumArtDownload(sourceType, TrackIndex, m_u16CurrentSongFileType); //Place a request for AA download
       }
	}
    vSetAlbumArtDownloadStatus(albumartDownloadStatus);

}
/************************************************************************
*FUNCTION: 		vSetAlbumArtDownloadStatus()
*DESCRIPTION: 	vSetAlbumArtDownloadStatus used by Avdecc client will set the AlbumArt Download status
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void tClAlbumArt::vSetAlbumArtDownloadStatus(uint16_t DownloadStatus)
{
	ETG_TRACE_USR4(("tClAlbumArt vSetAlbumArtDownloadStatus DownloadStatus %d ",DownloadStatus));
	m_u8TFTPAlbumArtDLStatus = DownloadStatus; //AA download status from TFTP client
	
	if(DownloadStatus == entDownloadState_Downloadsuccess)
	{
		m_u8AlbumArtDLState = DOWNLOAD_COMPLETE;
	}
	else 
	{
		m_u8AlbumArtDLState = DOWNLOAD_ERROR;
	}
	vHandleAADownloadState();
	
}
/************************************************************************
*FUNCTION: 		UpdateAlbumArtDownloadStatus()
*DESCRIPTION: 	UpdateAlbumArtDownloadStatus updates AlbumArt download status to HMI
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/

void tClAlbumArt::vUpdateAlbumArtDownloadStatus(uint16_t DownloadState, uint16_t SongId)
{
	ETG_TRACE_USR4(("tClAlbumArt vUpdateAlbumArtDownloadStatus"));
	if(m_poHmiServiceAdaptor != NULL)
	{
	ETG_TRACE_USR4(("tClAlbumArt vUpdateAlbumArtDownloadStatus DownloadStatus %d songID %d",DownloadState,SongId));
	m_poHmiServiceAdaptor->sendSig_AlbumArtStateSignal(static_cast<bosch::cm::di::HmiEmpListInterface::entDownloadState>(DownloadState),SongId); 
	}//Update HMI with AA download status
	

}

/************************************************************************
*FUNCTION: 		vHandleAADownloadState()
*DESCRIPTION: 	vHandleAADownloadState 
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void tClAlbumArt:: vHandleAADownloadState()
{
	switch (m_u8AlbumArtDLState)
	{
			case IDLE :
                                m_u8AlbumArtDLState = DOWNLOAD_WAITING;
				ETG_TRACE_USR4(("tClAlbumArt vHandleAADownloadState IDLE  m_u16PrevTrackIndex %d m_u16CurrentTrackIndex %d",m_u16PrevTrackIndex,m_u16CurrentTrackIndex));
				m_u16PrevTrackIndex = m_u16CurrentTrackIndex;
				vFetchAlbumArt(m_u16SourceType, m_u16CurrentTrackIndex);//place AA download request when a song is being played
				break;
			
			case DOWNLOAD_WAITING:
				ETG_TRACE_USR4(("tClAlbumArt vHandleAADownloadState Download waiting "));
				break;
				
			case DOWNLOAD_COMPLETE:  				
				case DOWNLOAD_ERROR:
					vUpdateAlbumArtDownloadStatus(m_u8TFTPAlbumArtDLStatus,m_u16CurrentTrackIndex);//Send download ststus update to HMI when recieved response from TFTP client
                                        m_u8AlbumArtDLState = IDLE;
					ETG_TRACE_USR4(("tClAlbumArt vHandleAADownloadState m_u16CurrentTrackIndex %d m_u8TFTPAlbumArtDLStatus %d",m_u16CurrentTrackIndex,m_u8TFTPAlbumArtDLStatus));					
					vValidateAlbumArt();
					break;
			default :
				 break;
	}
	
}

/************************************************************************
*FUNCTION: 		UpdateUSBConnectionStatus()
*DESCRIPTION: 	UpdateUSBConnectionStatus
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
/*bool tClAlbumArt::UpdateUSBConnectionStatus(){//discuss

	return  NULL;
}*/

/************************************************************************
*FUNCTION: 		ValidateAlbumArt()
*DESCRIPTION: 	Validate if the album art is downloaded for that current track index.
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void tClAlbumArt::vValidateAlbumArt()
{
	
	ETG_TRACE_USR4(("tClAlbumArt  vValidateAlbumArt"));	
        if(m_u16PrevTrackIndex != m_u16CurrentTrackIndex)//Check if any new AA download request is being placed when downloading old AA
	{
	        ETG_TRACE_USR4(("tClAlbumArt vValidateAlbumArt  m_u16PrevTrackIndex %d m_u16CurrentTrackIndex %d",m_u16PrevTrackIndex,m_u16CurrentTrackIndex));
	        vHandleAADownloadState(); //Place a new download request
	}
}
