/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : EMPFactory.h
* COMPONENT Name      : di_middlewareserver
* DESCRIPTION         : A factory for all EMP_Listhanler classes
* AUTHOR              : Apoorva C S
* Date                : 13/08/2021
* Revision History    : 0.1
* Date 13/08/2021     : Initial version
****************************************************************************/

#ifndef EMPFactory_HEADER
#define EMPFactory_HEADER

#include "TFTPClientBase.h"
#include "TFTPClientCMP.h"
#include "TFTPClientCMR.h"
#include "clCMRProcessThread.h"
#include "clCMPProcessThread.h"
#include "clListHandlerCoreThread.h"
#include "CMPListHandlerLogic.h"
#include "CMRListHandlerLogic.h"
#include "ListHandlerLogic.h"

class EMPFactory
{
  public:
    virtual ~EMPFactory();
    TFTPClientBase* getTFTPClientreference(const EnumConst::entSourceType enSourceType);
    clListHandlerCoreThread* getListHandlerthreadReference(const EnumConst::entSourceType enSourceType);
    tclListHandlerLogic* getListHandlerLogicReference(const EnumConst::entSourceType enSourceType);
    static EMPFactory* getEmpFactoryReference();

  private:
    static EMPFactory* EmpFactoryinstance;
    TFTPClientCMR* po_TFTPClientCMR;
    TFTPClientCMP* po_TFTPClientCMP;
    clCMRProcessThread *po_CMRProcessThread;
    clCMPProcessThread *po_CMPProcessThread;
    CMRListHandlerLogic* m_pCMRListHandlerLogic;
    CMPListHandlerLogic* m_pCMPListHandlerLogic;
    EMPFactory();

};
#endif