/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : EMPFactory.cpp
* COMPONENT Name      : di_middlewareserver
* DESCRIPTION         : A factory for TFTP clients
* AUTHOR              : Apoorva C S
* Date                : 13/08/2021
* Revision History    : 0.1
* Date 13/08/2021     : Initial version
****************************************************************************/

#include "EMPFactory.h"

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_TFTPCLIENT
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/EMPFactory.cpp.trc.h"
#endif

EMPFactory* EMPFactory::EmpFactoryinstance = NULL;

EMPFactory::EMPFactory()
{
    ETG_TRACE_USR4(("EMPFactory::constructor()"));
    po_TFTPClientCMR = new TFTPClientCMR();
    po_TFTPClientCMP = new TFTPClientCMP();
    po_CMRProcessThread = clCMRProcessThread::getInstance();
	po_CMPProcessThread = clCMPProcessThread::getInstance();
    m_pCMRListHandlerLogic = CMRListHandlerLogic::getInstance();
    m_pCMPListHandlerLogic = CMPListHandlerLogic::getInstance();
}

EMPFactory::~EMPFactory()
{
    ETG_TRACE_USR4(("EMPFactory::destructor()"));
    if(po_TFTPClientCMR != NULL)
    {
        delete po_TFTPClientCMR;
        po_TFTPClientCMR = NULL;
    }
    if(po_TFTPClientCMP != NULL)
    {
        delete po_TFTPClientCMP;
        po_TFTPClientCMP = NULL;
    }
    if(po_CMRProcessThread != NULL)
    {
        delete po_CMRProcessThread;
        po_CMRProcessThread = NULL;
    }
    if(po_CMPProcessThread != NULL)
    {
        delete po_CMPProcessThread;
        po_CMPProcessThread = NULL;
    }
    if(m_pCMRListHandlerLogic != NULL)
    {
        delete m_pCMRListHandlerLogic;
        m_pCMRListHandlerLogic = NULL;
    }
    if(m_pCMPListHandlerLogic != NULL)
    {
        delete m_pCMPListHandlerLogic;
        m_pCMPListHandlerLogic = NULL;
    }
    if (EmpFactoryinstance != NULL)
	{
		delete EmpFactoryinstance;
        EmpFactoryinstance = NULL;
	}
}

TFTPClientBase* EMPFactory::getTFTPClientreference(const EnumConst::entSourceType enSourceType)
{
    ETG_TRACE_USR4(("EMPFactory::getTFTPClientreference() SourceType %d", enSourceType));
    //fetching reference based on source type
    if (enSourceType == EnumConst::entSourceType_CMR && po_TFTPClientCMR != NULL)
    {
        return po_TFTPClientCMR;
    }
    if (enSourceType == EnumConst::entSourceType_CMP && po_TFTPClientCMP != NULL) 
    {
        return po_TFTPClientCMP;
    }
    ETG_TRACE_USR4(("EMPFactory::getListHandlerLogicReference() Error! Null or invalid SourceType"));
    return NULL;
}

clListHandlerCoreThread* EMPFactory::getListHandlerthreadReference(const EnumConst::entSourceType enSourceType)
{
    ETG_TRACE_USR4(("EMPFactory::getListHandlerthreadReference() SourceType %d", enSourceType));
    if (enSourceType == EnumConst::entSourceType_CMR && po_CMRProcessThread != NULL)
    {
        return po_CMRProcessThread;
    }
    if (enSourceType == EnumConst::entSourceType_CMP && po_CMPProcessThread != NULL) 
    {
        return po_CMPProcessThread;
    }
    ETG_TRACE_USR4(("EMPFactory::getListHandlerLogicReference() Error! Null or invalid SourceType"));
    return NULL;
}

tclListHandlerLogic* EMPFactory::getListHandlerLogicReference(const EnumConst::entSourceType enSourceType)
{
    ETG_TRACE_USR4(("EMPFactory::getListHandlerLogicReference() SourceType %d", enSourceType));
    if (enSourceType == EnumConst::entSourceType_CMR && m_pCMRListHandlerLogic != NULL)
    {
        return m_pCMRListHandlerLogic;
    }
    if (enSourceType == EnumConst::entSourceType_CMP && m_pCMPListHandlerLogic != NULL) 
    {
        return m_pCMPListHandlerLogic;
    }
    ETG_TRACE_USR4(("EMPFactory::getListHandlerLogicReference() Error! Null or invalid SourceType"));
    return NULL;
}

EMPFactory* EMPFactory::getEmpFactoryReference()
{
    ETG_TRACE_USR4(("EMPFactory::getEmpFactoryReference()"));
    if (NULL == EmpFactoryinstance)
	{
		EmpFactoryinstance = new EMPFactory();
	}
	return EmpFactoryinstance;
}
