/************************************************************************
*FILE:			 EMPListTraceConfig.h
*SW-COMPONENT:	 EMPLISTHANDLER
*DESCRIPTION: 	 Defines the Trace Class IDs for EMPListHandler component
*AUTHOR:         Deepak Babu K
*COPYRIGHT: 	 (c)  Robert Bosch Car Multimedia GmbH
*HISTORY:
*28.07.20 Rev. 0.1 Deepak Babu K
* 		   		 Initial Revision.
************************************************************************/

#ifndef EMPLISTTRACECONFIG_HEADER
#define EMPLISTTRACECONFIG_HEADER

/*****************************************************************
| includes 
|----------------------------------------------------------------*/
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

#define ETG_ENABLED
#ifndef EMPLISTHANDLER_UNIT_TEST
#ifdef TEST_EMPLIST
	extern "C" void vInitPlatformEtg(void);
#else
	#include "trace_interface.h"
#endif 
#endif
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "trace_if.h"
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
//TODO:BAE2COB
#define TR_COMP_EMPLISTHANDLER_APP 0x6400 // Trace Component ID

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/

typedef enum 
{
   /* Temporarily, the Trace Component ID TR_COMP_EMPLISTHANDLER_APP 
      is used for EMP List handler */
   TR_CLASS_LISTHANDLER_CLIENT = TR_COMP_EMPLISTHANDLER_APP, 
   TR_CLASS_LISTHANDLER_LOGIC,
   TR_CLASS_LISTHANDLER_ALBUMART,
   TR_CLASS_LISTHANDLER_ASF,
   TR_CLASS_LISTHANDLER_TFTPCLIENT,
   TR_CLASS_LISTHANDLER_DBMANAGER
   
} emp_tenListHandlerTraceClassId;

#endif // EMPLISTHANDLERTRACECONFIG_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
