/* ***************************************************************************************
 * FILE:          AsfEmpListHmiServiceAdaptor.cpp
 * SW-COMPONENT:  DI_MIDDLEWARE_SERVER
 * DESCRIPTION:   AsfEmpListHmiServiceAdaptor.cpp is part of EMP_LIST DBUS
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Madhuree
 * Date: 20.07.2020
 * Revision: 
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
 
#include "AsfEmpListHmiServiceAdaptor.h"
#include "../AvdeccClient/AvdeccPluginConstant.h"
#include "../AvdeccClient/AvdeccClientHandler.h"
#include <stdio.h>
#include <vector>
#include <iterator>
#include "../../ListController/ListHandler/ListHandlerTypes.h"
#include "clListHandlerCoreThread.h"
#include "ListHandlerLogic.h"
#include "asf/core/Utf8String.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_rse_if.h"

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_ASF
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/AsfEmpListHmiServiceAdaptor.cpp.trc.h"
#endif

using namespace ::asf::core;
using namespace listHandlerTypes;
// ========================================================================
namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {
#define EMPLISTHMI_PORT_NAME "EmpListHmiPort"

/* Pointer to the singleton class object*/
	clAsfEmpListHmiServiceAdaptor* clAsfEmpListHmiServiceAdaptor::p_AsfEmpListHmiInstance = NULL;
	
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION: 	GetInstance will return the pointer to the clAsfEmpListHmiServiceAdaptor
*				Singleton Object
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
clAsfEmpListHmiServiceAdaptor* clAsfEmpListHmiServiceAdaptor::getInstance()
{

	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getInstance()"));
	if (p_AsfEmpListHmiInstance == NULL)
	{
		ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getInstance Creating Instance"));
		p_AsfEmpListHmiInstance = new clAsfEmpListHmiServiceAdaptor();
	}
	return p_AsfEmpListHmiInstance;
}

/************************************************************************
*FUNCTION: 		clAsfEmpListHmiServiceAdaptor()
*DESCRIPTION: 	 Constructor of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/	
clAsfEmpListHmiServiceAdaptor::clAsfEmpListHmiServiceAdaptor() :
	HmiEmpListInterfaceStub(EMPLISTHMI_PORT_NAME)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor() constructor"));
    m_poEmpFactory = EMPFactory::getEmpFactoryReference();
    mapSelectedLanguageIds[EnumConst::entSourceType_CMP] = {};
    mapSelectedLanguageIds[EnumConst::entSourceType_CMR] = {};
    vReadDataPools();

}

/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION: 	vDeleteInstance will delete clAsfEmpListHmiServiceAdaptor
*				Singleton Object
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
void clAsfEmpListHmiServiceAdaptor::vDeleteInstance()
{
	if (p_AsfEmpListHmiInstance != NULL)
	{
		ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vDeleteInstance()"));
		delete p_AsfEmpListHmiInstance;
		p_AsfEmpListHmiInstance = NULL;
	}
}

/************************************************************************
*FUNCTION: 		~clAsfEmpListHmiServiceAdaptor()
*DESCRIPTION: 	clAsfEmpListHmiServiceAdaptor class Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
*************************************************************************/
clAsfEmpListHmiServiceAdaptor::~clAsfEmpListHmiServiceAdaptor()
{
}


void clAsfEmpListHmiServiceAdaptor::onListSizeGet(const ::boost::shared_ptr< ListSizeGet >& payload)
{
}
void clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerListSliceRequest >& request)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerListSliceRequest()"));
   stWindowSliceRequest windowrequest;
   windowrequest.ListType = static_cast<EnumConst::entListType>(request->getListType());
   windowrequest.SourceType = static_cast<EnumConst::entSourceType>(request->getSourceType());
   windowrequest.Region = request -> getRegion();
   windowrequest.startIndex = request->getStartingIndex();
   windowrequest.windowSize = request->getWindowSize();
   
   //print values received from HMI for debugging
   ETG_TRACE_USR4(("onReqMediaPlayerListSliceRequest()ListType: %d", windowrequest.ListType));
   ETG_TRACE_USR4(("onReqMediaPlayerListSliceRequest()SourceType: %d", windowrequest.SourceType));
   ETG_TRACE_USR4(("onReqMediaPlayerListSliceRequest()Region: %d", windowrequest.Region));
   ETG_TRACE_USR4(("onReqMediaPlayerListSliceRequest()startIndex: %d", windowrequest.startIndex));
   ETG_TRACE_USR4(("onReqMediaPlayerListSliceRequest()windowSize: %d", windowrequest.windowSize));

   if (NULL != m_poEmpFactory)
   {
       clListHandlerCoreThread* poListHandlerCoreThread = m_poEmpFactory->getListHandlerthreadReference(windowrequest.SourceType);
	   if(poListHandlerCoreThread != NULL)
       {
           poListHandlerCoreThread->setListRequestEvent(windowrequest);
       }
   }
}

void clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerFolderListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceRequest >& request)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerFolderListSliceRequest()"));
   stWindowSliceRequest windowrequest;
   windowrequest.ListType = EnumConst::entListType_Folder;
   windowrequest.SourceType = static_cast<EnumConst::entSourceType>(request->getSourceType());
   windowrequest.Region = request -> getRegion();
   windowrequest.startIndex = request->getStartingIndex();
   windowrequest.windowSize = request->getWindowSize();
   windowrequest.FolderPath = request->getFolderPath();
   
   
   //print values received from HMI for debugging
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()ListType: %d", windowrequest.ListType));
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()SourceType: %d", windowrequest.SourceType));
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()Region: %d", windowrequest.Region));
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()startIndex: %d", windowrequest.startIndex));
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()windowSize: %d", windowrequest.windowSize));
   ETG_TRACE_USR4(("onReqMediaPlayerFolderListSliceRequest()Folderpath: %s", windowrequest.FolderPath.c_str()));

   if (NULL != m_poEmpFactory)
   {
       clListHandlerCoreThread* poListHandlerCoreThread = m_poEmpFactory->getListHandlerthreadReference(windowrequest.SourceType);
	   if(poListHandlerCoreThread != NULL)
       {
           poListHandlerCoreThread->setListRequestEvent(windowrequest);
       }
   }
}

void clAsfEmpListHmiServiceAdaptor::onReqDBDownloadRequest (const ::boost::shared_ptr< ReqDBDownloadRequest >& request)
{
    EnumConst::entSourceType sourceType = static_cast<EnumConst::entSourceType>(request -> getSourceType());
    ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqDBDownloadRequest() is no longer valid %d", sourceType));
    EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler *poAvdeccClientHandler = EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();
    if(nullptr != poAvdeccClientHandler)
    {
        poAvdeccClientHandler->bRequestDBDownload(sourceType);
    }
}

void clAsfEmpListHmiServiceAdaptor::onReqCreateMediaPlayerListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerListRequest >& request)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqCreateMediaPlayerListRequest()"));
   EnumConst::entListType listType = static_cast<EnumConst::entListType>(request -> getListType());
   EnumConst::entSourceType sourceType = static_cast<EnumConst::entSourceType>(request -> getSourceType());
   uint8 region = request -> getRegion();
   uint16 absoluteIndex = request -> getAbsoluteIndex();
   std::string FolderPath;//empty string

   //print values received from HMI for debugging
   ETG_TRACE_USR4(("onReqCreateMediaPlayerListRequest() listType: %d", listType));
   ETG_TRACE_USR4(("onReqCreateMediaPlayerListRequest() sourceType: %d", sourceType));
   ETG_TRACE_USR4(("onReqCreateMediaPlayerListRequest() region: %d", region));
   ETG_TRACE_USR4(("onReqCreateMediaPlayerListRequest() absoluteIndex: %d", absoluteIndex));

   if (NULL != m_poEmpFactory)
   {
      tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(sourceType);
      if(poListHandlerLogic != NULL)
      {
          poListHandlerLogic->vRequestCreateMediaPlayerList(listType, sourceType, region, FolderPath);     
      }
   }
}

void clAsfEmpListHmiServiceAdaptor::onReqCreateMediaPlayerFolderListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListRequest >& request)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqCreateMediaPlayerFolderListRequest()"));
   EnumConst::entSourceType sourceType = static_cast<EnumConst::entSourceType>(request -> getSourceType());
   uint8 region = request -> getRegion();
   std::string FolderPath = request -> getFolderPath();

   //print values received from HMI for debugging
   ETG_TRACE_USR4(("onReqCreateMediaPlayerFolderListRequest() sourceType: %d", sourceType));
   ETG_TRACE_USR4(("onReqCreateMediaPlayerFolderListRequest() region: %d", region));
   ETG_TRACE_USR4(("onReqCreateMediaPlayerFolderListRequest() FolderPath: %s", FolderPath.c_str()));

   if (NULL != m_poEmpFactory)
   {
      tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(sourceType);
      if(poListHandlerLogic != NULL)
      {
          poListHandlerLogic->vRequestCreateMediaPlayerList(EnumConst::entListType_Folder, sourceType, region, FolderPath);     
      }
   }
}

void clAsfEmpListHmiServiceAdaptor::sendSig_DBStateSignal(bosch::cm::di::HmiEmpListInterface::entDownloadState downloadState, bosch::cm::di::HmiEmpListInterface::entSourceType sourceType)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::sendSig_DBStateSignal() DB downloadState:%d sourceType:%d",downloadState,sourceType));
   HmiEmpListInterfaceStub::sendSig_DBStateSignal(downloadState,sourceType);
}
void clAsfEmpListHmiServiceAdaptor::sendSig_AlbumArtStateSignal(bosch::cm::di::HmiEmpListInterface::entDownloadState downloadState, uint16 songId)
{
   ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::sendSig_AlbumArtStateSignal() AA downloadState:%d, songId:%d",downloadState,songId));
   HmiEmpListInterfaceStub::sendSig_AlbumArtStateSignal(downloadState,songId);
}

void clAsfEmpListHmiServiceAdaptor::setListSize(const uint16_t u16count, EnumConst::entListType enRequestedListType, \
                    EnumConst::entSourceType enRequestedListSourceType, uint8_t u8RequestedListRegion)
{
    ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setListSize()"));
    
    ListSizeStruct listSize;
	listSize.setCount(u16count);
	listSize.setListType(static_cast <bosch::cm::di::HmiEmpListInterface::entListType>(enRequestedListType));
	listSize.setSourceType(static_cast <bosch::cm::di::HmiEmpListInterface::entSourceType> (enRequestedListSourceType));
	listSize.setRegion(u8RequestedListRegion);
    
    if(EnumConst::entListType_Folder == enRequestedListType)
    {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setListSize for type folder()"));
        HmiEmpListInterfaceStub::sendReqCreateMediaPlayerFolderListResponse(listSize.getCount());
    }
    else
    {
        ListSizeStruct availableListSize = HmiEmpListInterfaceStub::getListSize();
        uint16_t availableCount = availableListSize.getCount();
        EnumConst::entListType availableListType = static_cast<EnumConst::entListType>(availableListSize.getListType());
    
        if(availableCount == listSize.getCount() && availableListType == listSize.getListType() )
        {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setListSize() same list type is requested "));
        HmiEmpListInterfaceStub::sendListSizeUpdate();
        }
        else
        {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setListSize() Change in list type or count, set the attribute "));
            HmiEmpListInterfaceStub::setListSize(listSize);
        }
    }
}

void clAsfEmpListHmiServiceAdaptor::UpdateMediaPlayerListSliceResponse(dbManagerTypes::ItemList vecListData, const EnumConst::entSourceType eSourceType, EnumConst::entListType enListType)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerListSliceResponse()"));
	std ::vector<ListContainerStruct> ListData;
	dbManagerTypes::ItemList::iterator itr2;
	if (vecListData.size() > 0)
	{ 
		for (itr2 = vecListData.begin(); itr2 != vecListData.end() ; itr2++)
		{
            bool IsLanguageSelected = false;
            if(enListType == EnumConst::entListType_Video_Languages)
            {
                if(std::find(mapSelectedLanguageIds[eSourceType].begin(), mapSelectedLanguageIds[eSourceType].end(), itr2->getAbsoluteIndex()) != mapSelectedLanguageIds[eSourceType].end() )
                {
                    IsLanguageSelected = true; // Language selected
                }
            }
            //utf8 validation Task 1498142
            RenameifInvalidUTF8isFound(itr2->firstString);
            RenameifInvalidUTF8isFound(itr2->secondString);

			ListContainerStruct ListItem(itr2->getFirstString(),itr2->getSecondString(),itr2->getAbsoluteIndex(),IsLanguageSelected, static_cast<bosch::cm::di::HmiEmpListInterface::entFileType> (itr2->getFileType()));
			ListData.push_back(ListItem); 
		} 
		ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onReqMediaPlayerListSliceResponse send ReqMediaPlayerListSliceResponse()"));
		if(enListType == EnumConst::entListType_Folder)
        {
            HmiEmpListInterfaceStub::sendReqMediaPlayerFolderListSliceResponse(ListData);
        }
        else
        {
            HmiEmpListInterfaceStub::sendReqMediaPlayerListSliceResponse(ListData);
        }
	}
	else 
	{
		std::string errorName = "org.freedesktop.DBus.Error.Failed";
		std::string errorMessage = "EMPTY LIST";
		ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::sendReqMediaPlayerListSliceResponse() Sending error"));
		HmiEmpListInterfaceStub::sendReqMediaPlayerListSliceError(errorName,errorMessage);
	}
		
}

void clAsfEmpListHmiServiceAdaptor::vSendSig_PlayableFlagSignal(bool isPlayableAudio, bool isPlayableVideo,  bosch::cm::di::HmiEmpListInterface::entSourceType sourceType)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vSendSig_PlayableFlagSignal isPlayableAudio %d ,isPlayableVideo %d ",isPlayableAudio,isPlayableVideo));
	HmiEmpListInterfaceStub::sendSig_PlayableFlagSignal(isPlayableAudio,isPlayableVideo, sourceType);
}

void clAsfEmpListHmiServiceAdaptor::vSendsig_CurrentTrackInfoSignal(bosch::cm::di::HmiEmpListInterface::entSourceType enSourceType, bosch::cm::di::HmiEmpListInterface::entListType enListType, \
                                                uint8 u8_Region, uint16 songId, std::string sFolderPath)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vSendsig_CurrentTrackInfoSignal"));
	HmiEmpListInterfaceStub::sendSig_CurrentTrackInfoSignal(enSourceType, enListType, u8_Region, songId, sFolderPath);
}

void clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest (const ::boost::shared_ptr< SetMediaVideoLanguagesListRequest >& request)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest"));
    uint8 region = request->getRegion();
    EnumConst::entSourceType enSourceType = static_cast<EnumConst::entSourceType>(request->getSourceType());
    std::vector<uint16> vecSelectedLanguageIds = request->getVideoLanguageIds();
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest SourceType: %d", enSourceType));
	for(auto i : vecSelectedLanguageIds)
    {
        //printing ids updated by HMI
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest Language ID : %d", i));
    }

    if(mapSelectedLanguageIds[enSourceType] == vecSelectedLanguageIds)
    {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest, no change in selected language list"));
    }
    else
    {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest change in selected languages"));
        mapSelectedLanguageIds[enSourceType].clear();
        mapSelectedLanguageIds[enSourceType] = vecSelectedLanguageIds;
        uint32 Array_Size = vecSelectedLanguageIds.size();
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::onSetMediaVideoLanguagesListRequest Size of list %d", Array_Size));
        uint16 SelectedLanguages[Array_Size];
        std::copy(vecSelectedLanguageIds.begin(), vecSelectedLanguageIds.end(), SelectedLanguages);

        //CMP Language dp write
        if(enSourceType = EnumConst::entSourceType_CMP)
        {
            setSelectedLanguages_CMPSize(Array_Size);
            dp_tclEMP_LHSelectedMediaLanguages_CMP dp_SelectedLanguages_CMP;
            dp_SelectedLanguages_CMP.s32SetData(SelectedLanguages, Array_Size);
        }
        //CMR Language dp write
        if(enSourceType = EnumConst::entSourceType_CMR)
        {
            setSelectedLanguages_CMRSize(Array_Size);
            dp_tclEMP_LHSelectedMediaLanguages_CMR dp_SelectedLanguages_CMR;
            dp_SelectedLanguages_CMR.s32SetData(SelectedLanguages, Array_Size);
        }
    }
}

std::vector<uint16> clAsfEmpListHmiServiceAdaptor::vecGetSelectedLanguages(EnumConst::entSourceType enSourceType)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vecGetSelectedLanguages"));
    for(auto i : mapSelectedLanguageIds[enSourceType])
    {
        ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vecGetSelectedLanguages Language ID : %d", i));
    }
    return mapSelectedLanguageIds[enSourceType];
}

void clAsfEmpListHmiServiceAdaptor::vClearSelectedLanguages(EnumConst::entSourceType enSourceType)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vClearSelectedLanguages"));
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vClearSelectedLanguages SourceType %d", enSourceType));
    mapSelectedLanguageIds[enSourceType].clear();
    //clear datapools
    //CMP Language dp write
    if(enSourceType = EnumConst::entSourceType_CMP)
    {
        setSelectedLanguages_CMPSize(ID_DEFAULT_ZERO);
    }
   //CMR Language dp write
    if(enSourceType = EnumConst::entSourceType_CMR)
    {
        setSelectedLanguages_CMRSize(ID_DEFAULT_ZERO);
    }
}

void clAsfEmpListHmiServiceAdaptor::vReadDataPools()
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vReadDataPools"));
    //READ CMP DATAPOOL
    mapSelectedLanguageIds[EnumConst::entSourceType_CMP].clear();
    dp_tclEMP_LHSelectedMediaLanguages_CMP dp_SelectedLanguages_CMP;
    uint16 SelectedLanguages_CMPSize = getSelectedLanguages_CMPSize();
    if(SelectedLanguages_CMPSize>0)
    {
        uint16 SelectedLanguages_CMP[SelectedLanguages_CMPSize] = {ID_DEFAULT_INVALID};
        dp_SelectedLanguages_CMP.s32GetData(SelectedLanguages_CMP, SelectedLanguages_CMPSize);
        for(int i=0;i<SelectedLanguages_CMPSize;i++)
        {
            ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vReadDataPools CMP langId : %d", SelectedLanguages_CMP[i]));
            mapSelectedLanguageIds[EnumConst::entSourceType_CMP].push_back(SelectedLanguages_CMP[i]);
        }
    }
    //READ CMR DATAPOOL
    mapSelectedLanguageIds[EnumConst::entSourceType_CMR].clear();
    dp_tclEMP_LHSelectedMediaLanguages_CMR dp_SelectedLanguages_CMR;
    uint16 SelectedLanguages_CMRSize = getSelectedLanguages_CMRSize();
    if(SelectedLanguages_CMRSize>0)
    {
        uint16 SelectedLanguages_CMR[SelectedLanguages_CMRSize] = {ID_DEFAULT_INVALID};
        dp_SelectedLanguages_CMR.s32GetData(SelectedLanguages_CMR, SelectedLanguages_CMRSize);
        for(int i=0;i<SelectedLanguages_CMRSize;i++)
        {
            ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::vReadDataPools CMR langId : %d", SelectedLanguages_CMR[i]));
            mapSelectedLanguageIds[EnumConst::entSourceType_CMR].push_back(SelectedLanguages_CMR[i]);
        }
    }
}

uint16 clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMPSize()
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMPSize"));
    uint16 Languages_CMPSize = 0;
    dp_tclEMP_LHSelectedMediaLanguages_CMPSize dp_SelectedMediaLanguages_CMPSize;
    dp_SelectedMediaLanguages_CMPSize.s32GetData(Languages_CMPSize);
    ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMPSize %d", Languages_CMPSize));
    return Languages_CMPSize;
}

void clAsfEmpListHmiServiceAdaptor::setSelectedLanguages_CMPSize(uint16 Languages_CMPSize)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setSelectedLanguages_CMPSize %d", Languages_CMPSize));
    dp_tclEMP_LHSelectedMediaLanguages_CMPSize dp_SelectedMediaLanguages_CMPSize;
    dp_SelectedMediaLanguages_CMPSize.s32SetData(Languages_CMPSize);
}

uint16 clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMRSize()
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMRSize"));
    uint16 Languages_CMRSize = 0;
    dp_tclEMP_LHSelectedMediaLanguages_CMRSize dp_SelectedMediaLanguages_CMRSize;
    dp_SelectedMediaLanguages_CMRSize.s32GetData(Languages_CMRSize);
    ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::getSelectedLanguages_CMRSize %d", Languages_CMRSize));
    return Languages_CMRSize;
}

void clAsfEmpListHmiServiceAdaptor::setSelectedLanguages_CMRSize(uint16 Languages_CMRSize)
{
	ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::setSelectedLanguages_CMRSize %d", Languages_CMRSize));
    dp_tclEMP_LHSelectedMediaLanguages_CMRSize dp_SelectedMediaLanguages_CMRSize;
    dp_SelectedMediaLanguages_CMRSize.s32SetData(Languages_CMRSize);
}

void clAsfEmpListHmiServiceAdaptor::RenameifInvalidUTF8isFound(std::string &Name)
{
    ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::RenameifInvalidUTF8isFound"));
    if (Name.length() > 0)
    {
        if (!Utf8String::isValid(Name))
        {
            ETG_TRACE_USR4(("clAsfEmpListHmiServiceAdaptor::RenameifInvalidUTF8isFound Invalid"));
            Name.assign("Unknown Name");
        }
    }
}

}
}
}
