/**************************************************************************************
* @file         : AvdeccClientHandler.h
* @author       : RBEI/ECG5-INF4CV
* @addtogroup   : Di_MiddlewareServer
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef AVDECCCLIENTHANDLER_H
#define AVDECCCLIENTHANDLER_H

#include <map>
#include "bosch/cm/ai/PluginDbusInterfaceProxy.h"
#include "bosch/cm/ai/PluginDbusInterface.h"
#include "bosch/cm/ai/PluginDbusInterfaceJson.h"
#include "bosch/cm/ai/PluginDbusInterfaceClientBase.h"
#include "bosch/cm/ai/PluginDbusInterfaceDBus.h"
#include "asf/core/BaseComponent.h"
#include "AvdeccPluginConstant.h"
#include "tClAlbumArt.h"
#include "EMPFactory.h"
#include "SelectQueryDAO.h"


using namespace asf::core;
using namespace ::bosch::cm::ai::PluginDbusInterface;

namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {
class AvdeccClientHandler
   : public ServiceAvailableIF,
     public Sig_PlayStatusCallbackIF,
     public Sig_DBStatusCallbackIF,
     public DBStateCallbackIF,
     public Sig_ReqTrackIndexCallbackIF,
     public Sig_CRCCheckStatusCallbackIF,
     public PlayBackModeCallbackIF

{
   public:

      virtual ~AvdeccClientHandler();
      static AvdeccClientHandler* poGetInstance();
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange) ;
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange) ;

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void onSig_PlayStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusError >& error);
      virtual void onSig_PlayStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusSignal >& signal);
      virtual void onSig_DBStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusError >& error) ;
      virtual void onSig_DBStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusSignal >& signal) ;
      virtual void onDBStateUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateUpdate >& update);
      void vsetListAbsoluteTrackIndex(bool isTrackIndexAvailable, uint32_t listAbsTrackIndex, uint16_t srcType, uint16_t FileType);
      virtual void onDBStateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateError >& error);
      virtual void onSig_ReqTrackIndexError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexError >& error);
      virtual void onSig_ReqTrackIndexSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexSignal >& signal);
      virtual void onSig_CRCCheckStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusError >& error);
      virtual void onSig_CRCCheckStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusSignal >& signal);
      // Callback 'PlayBackModeCallbackIF'
      virtual void onPlayBackModeError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeError >& error);
      virtual void onPlayBackModeUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeUpdate >& update);
      void vUpdateDBAvialabilityStatus(const EnumConst::entDbState eDBAvailStatus , const EnumConst::entSourceType enSourceType);
      void bRequestDBDownload(EnumConst::entSourceType SourceType);
      void vCheckPlayableItem(EnumConst::entSourceType SourceType);
      void vUpdateDBDownloadState(const EnumConst::entDownloadState enState,EnumConst::entSourceType SourceType);
    EnumConst::entDbState en_getDBAvailability(EnumConst::entSourceType enSourceType);
    EnumConst::entDownloadState en_getDBDownloadState(EnumConst::entSourceType enSourceType);
    bool bgetCRCStatus(EnumConst::entSourceType enSourceType);
    EnumConst::enPlayback_Modes enGetPlayBackMode(EnumConst::enSubSourceType en_SubSource_Type);
    void enSetPlayBackMode(EnumConst::enPlayback_Modes enPlayMode, uint16_t u16Region, EnumConst::entSourceType enSourceType, EnumConst::enSubSourceType enSubSource);


private:
      AvdeccClientHandler();
      static AvdeccClientHandler* m_poSelfAvdeccClientHandler;
      tClAlbumArt* m_poAlbumArt;
      EMPFactory* m_poEmpFactory;
      SelectQueryDAO *poSelectQueryDAO;
      ::boost::shared_ptr< PluginDbusInterfaceProxy > m_poPluginDbusProxy;
      
      typedef struct
        {
            EnumConst::entDbState en_DBAvailability;
            EnumConst::entDownloadState en_DBDownloadState;
            bool m_bCRCStatus;
            bool m_bIsDBInit;
        }stDBSourceData;
        map <EnumConst::entSourceType, stDBSourceData> mapSourceData;

      typedef struct
      {
          EnumConst::enPlayback_Modes enPlayBackMode;
          uint16_t Region;
          EnumConst::entSourceType enSource;
      }stPlayBackModeData;
      map <EnumConst::enSubSourceType, stPlayBackModeData> mapPlayBackModeData;
};


}
}
}


#endif
