/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : QueryManager.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 23.07.2021
 * Revision History    : 1.0
 * Date 7.07.2020     : Initial version
 *
*/


#ifndef I_BASE_SOURCE_H_
#define I_BASE_SOURCE_H_
#include <string>
#include <vector>
#include <map>
#include <dbManagerTypeDefs.h>
#include <dbManagerQueryTypes.h>
#include <SelectQueryDAO.h>

using namespace dbManagerTypes;



class IBaseSource
{

public:

//IBaseSource();

    virtual ~IBaseSource() {};

    virtual bool setDBPath ( string dbPath ) = 0;

    virtual string getDBPath () = 0;

    virtual bool setDBStatus ( bool dbStatus ) = 0;

    virtual bool getDBStatus () = 0;

    virtual void setQueryStateMent ( sqlite3_stmt *stmt ) = 0;

    virtual sqlite3_stmt* getQueryStateMent () = 0;

    virtual bool init () = 0;

    virtual bool deInit () = 0;

    virtual bool openDB () = 0 ;

    virtual bool closeDB () = 0;

    virtual sqlite3 * getDB () = 0;

    virtual void setDB ( sqlite3 * db ) = 0;

    virtual void setRootFolderPath ( string rootPath ) = 0;

    virtual string getRootFolderPath () = 0;
	
	virtual void setAbsoluteFolderPath ( string requestFolderPath ) = 0;
	
	virtual string getAbsoluteFolderPath () = 0;





};
#endif /* BaseSource */
