/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : SelectQueryDAO.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 7.07.2020
 * Revision History    : 1.0
 * Date 7.07.2020     : Initial version
 *
*/


#ifndef SELECT_QUERY_DAO_H_
#define SELECT_QUERY_DAO_H_

#include <QueryManager.h>

#include <dbManagerTypeDefs.h>

using namespace dbManagerTypes;

class SelectQueryDAO
{
public:

    // constructor
    SelectQueryDAO();
    //destructor
    virtual ~SelectQueryDAO();
	
	virtual void SetUp(){
	}

	virtual void TearDown(){
	}

    // getInstance
    static SelectQueryDAO *getInstance()
    {
        if (!m_SelectQueryDAO)
            m_SelectQueryDAO = new SelectQueryDAO;
        return m_SelectQueryDAO;
    }

    // init
    bool init ( eSourceType sourceType = entSourceType_CMP );

    //deinit

    bool deinit ( eSourceType sourceType = entSourceType_CMP );

    // getListCount

    bool getListCount ( sRequestCount& vRequestCount, uint16_t& count );

    // getWindowListSliced

    bool getWindowListSliced ( sRequestMessage& vRequestMessage, ItemList& vItemList );

    // getNextpreviousSong

    bool getNextPreviousSongId ( sRequestSongId& vRequestSongId, sResponseSongInfo& vResponseSongInfo );

    // playable status for video files

    pair <bool,eSourceType> hasPlayableVideoItem ( eSourceType sourceType = entSourceType_CMP );

    // playable status for audio files

    pair <bool,eSourceType> hasPlayableAudioItem ( eSourceType sourceType = entSourceType_CMP );

    // get the first song ID
    bool getFirstSongId ( sRequestFrontRearSong& vRequestFirstSong , sResponseSongInfo& vResponseSongInfo  );

    bool getListInfo( sReqListInfoMessage& vReqListMessage, ItemList &vItemList );

    // get the last song ID
    bool getLastSongId ( sRequestFrontRearSong& vRequestLastSong, sResponseSongInfo& vResponseSongInfo  );


private :

    static SelectQueryDAO* m_SelectQueryDAO ;

};

#endif /* SelectQueryDAO */
