/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginServerHandler.cpp
* COMPONENT Name      : PluginServer
* DESCRIPTION         : DBus server for plugins
*					         Receives command requests from HMI and sends it to plugin
*					         Receives updates from plugin and sends it to HMI
* AUTHOR              : Preethi Alagappan
* Date                : 14.09.2018
* Revision History    : 0.1
* Date 14.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Removed condition check for plugin and control block name.
*                       Moved the code, which converts EventDataUtility to Dbus variant
*                       and vice versa, to PluginDataConverter
* Revision History    : 0.3
* Date 15.11.2018     : Implementation for PluginListCommandRequest and PluginListUpdateSignal
****************************************************************************/

#ifndef PLUGIN_SERVER_HANDLER_HEADER
#define PLUGIN_SERVER_HANDLER_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "PluginDbusInterface.h"
#include "PluginDbusInterfaceStub.h"
#include "PluginDataConverter.h"
#include "PluginDataType.h"
#include <vector>

using namespace ::asf::core;
using namespace ::bosch::cm::ai::PluginDbusInterface;

class PluginServerHandler : public PluginDbusInterfaceStub
{
public:
   virtual ~PluginServerHandler();
   static PluginServerHandler* getInstance();

   void onPluginCommandRequest(const ::boost::shared_ptr< PluginCommandRequest >& request);
   void onPluginListCommandRequest(const ::boost::shared_ptr< PluginListCommandRequest >& request);

   void onPluginUpdateSignal(const std::string& pluginName,
                             const std::string& ctrlBlockName,
                             const boost::shared_ptr<EventDataUtility>& eventData);
   void onPluginListUpdateSignal(const std::string& pluginName,
                                 const std::string& ctrlBlockName,
                                 const boost::shared_ptr<EventDataUtility>& eventData,
                                 const boost::shared_ptr<EventListDataUtility>& listData);
   void EndStationListUpdateProperty(const boost::shared_ptr<EventDataUtility>& stationListData);
   void EntityDetailsListUpdateProperty(const boost::shared_ptr<EventListDataUtility>& eData);	
   void sendSig_PlayStatusSignalUpdate(bool playState,uint16_t sourceType,int songId,uint16_t Filetype,uint16_t Listtype,uint16_t Filter1,uint16_t Filter2,std::string Folderpath);
   void setListAbsoluteTrackIndexProperty(int32 listAbsoluteTrackIndex,int16 sourcetype);
   int32 getListAbsoluteTrackIndexProperty();

   void onListAbsoluteTrackIndexSet(const ::boost::shared_ptr< ListAbsoluteTrackIndexSet >& payload);
   void sendSig_DBStatusSignalUpdate(uint16_t dbState , uint16_t sourceType);
   void sendsig_ReqTrackIndex(uint16_t trackIndexAction,uint16_t sourceType,uint16_t ListType,uint16_t Filter1,uint16_t Filter2,uint16_t TrackIndex,uint16_t Region,std::string FolderPath);
   void sendsig_CRCCheckStatusUpdate(bool CRCStatus, uint16_t sourceType);
private:
   PluginServerHandler();
   PluginServerHandler(const PluginServerHandler&);
   PluginServerHandler& operator = (const PluginServerHandler&);
   
};

#endif
