/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginEvtListenerBase.h
* COMPONENT Name      :
* DESCRIPTION         : Template class for plugin event listeners
* AUTHOR              : Dalabehera Ruchismita
* Date                : 12.11.2018
* Revision History    : 0.1
* Date 12.11.2018     : Initial version
****************************************************************************/

#ifndef _ACAUDIOCONTROL_PLUGINEVTLISTENERBASE_H_
#define _ACAUDIOCONTROL_PLUGINEVTLISTENERBASE_H_

#include "PluginEventBase.h"
#include "EventHandler.hpp"
#include "EventBus.hpp"
#include "CommonPlugin.h"

template <class T>
class PluginEvtListenerBase:public EventHandler<PluginEventBase<T>>
{
public:
    virtual ~PluginEvtListenerBase() { }
    /**
     * This event handler prints out a debug message whenever event is fired and initiates plugin method
     *
     * @param e The PluginEventBase event
     */
    void onEvent(PluginEventBase<T>* e)
    {
        // Ignore the event if it's already been canceled
        if (e->Event::getCanceled()) {
            return;
        }

        if(e->getPlugin() != NULL)
        {
            bool IsListData = e->hasListData();
            if(!IsListData)
            {
                e->getPlugin()->setPluginData(e->getMessage().c_str(), e->getEventValue());
            }
            else
            {
                e->getPlugin()->setPluginListData(e->getMessage().c_str(), e->getEventValue(), e->getListEventData());
            }
        }
    }

    static PluginEvtListenerBase<T>* getInstance();
    static PluginEvtListenerBase<T>* _PluginEvtListenerInstance;
private:
    PluginEvtListenerBase(){}

};

template <>
void PluginEvtListenerBase<CommonPlugin>::onEvent(PluginEventBase<CommonPlugin>* e);

template<typename T>
PluginEvtListenerBase<T>* PluginEvtListenerBase<T>::_PluginEvtListenerInstance = NULL;

template<typename T>
PluginEvtListenerBase<T>* PluginEvtListenerBase<T>::getInstance()
{
    if(_PluginEvtListenerInstance == NULL)
    {
        _PluginEvtListenerInstance = new PluginEvtListenerBase<T>();
    }
    return _PluginEvtListenerInstance;
}


#endif
