/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginEventListenerBase.h
* COMPONENT Name      :
* DESCRIPTION         : template specialization for CommonPlugin,
* 						as it needs to know from which plugin the request has come
* AUTHOR              : Shanmugapriya Murugan
* Date                : 20.11.2018
* Revision History    : 0.1
* Date 20.11.2018     : Initial version
****************************************************************************/
#include "PluginEvtListenerBase.h"


/************************************************************************
*NAME        : onEvent
*DESCRIPTION : Design section 8.3.3 - PluginEventListener
************************************************************************/
template <>
void PluginEvtListenerBase<CommonPlugin>::onEvent(PluginEventBase<CommonPlugin>* e)
{
    // Ignore the event if it's already been canceled
    if (e->Event::getCanceled()) {
        return;
    }

    if(e->getPlugin() != NULL)
    {
        bool IsListData = e->hasListData();
        if(!IsListData)
        {
            e->getPlugin()->setPluginData(e->getSenderInfo(), e->getMessage().c_str(), e->getEventValue());
        }
        else
        {
           e->getPlugin()->setPluginListData(e->getSenderInfo(), e->getMessage().c_str(), e->getEventValue(), e->getListEventData());
        }
    }
}

