/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginEventBase.h
* COMPONENT Name      :
* DESCRIPTION         : This class will define events for plugin
* AUTHOR              : Dalabehera Ruchismita
* Date                : 27.09.2018
* Revision History    : 0.1
* Date 27.09.2018     : Initial version
* Revision History    : 0.2
* Date 20.11.2018     : To make it generic, modified PluginEventBase as a template class
****************************************************************************/

#ifndef _PLUGINEVENT_BASE_H_
#define _PLUGINEVENT_BASE_H_

#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"
#include "Event.hpp"



template <class T>
class PluginEventBase : public Event
{
public:
    PluginEventBase(Object* sender, T * const plugin, const std::string msg, const boost::shared_ptr<EventDataUtility>& evalue, const std::string sender_info = "") :
        Event(sender),
        plugin(plugin),
        msg(msg),
        mEventData(evalue),
        mSenderInfo(sender_info),
		mIsListData(false){
    }

    PluginEventBase(Object* sender, T * const plugin, const std::string msg, const boost::shared_ptr<EventDataUtility>& eData,
        const boost::shared_ptr<EventListDataUtility>& eListData, const std::string sender_info = "") :
        Event(sender),
        plugin(plugin),
        msg(msg),
        mEventData(eData),
		mEventListData(eListData),
        mSenderInfo(sender_info),
		mIsListData(true){
    }

    virtual ~PluginEventBase() { }

    T * const getPlugin() {
        return plugin;
    }

    const std::string getMessage() {
        return msg;
    }

    const boost::shared_ptr<EventDataUtility>& getEventValue() {
        return mEventData;
    }

    const boost::shared_ptr<EventListDataUtility>& getListEventData() {
    	return mEventListData;
    }

    const std::string getSenderInfo() {
        return mSenderInfo;
    }

    bool hasListData() {
    	return mIsListData;
    }

private:
    T * const plugin;
    const std::string msg;
    const boost::shared_ptr<EventDataUtility> mEventData;
    const boost::shared_ptr<EventListDataUtility> mEventListData;
    const std::string mSenderInfo;
    bool mIsListData;
};

#endif
