/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CommonPlugin.h
* COMPONENT Name      : CommandUtilities
* DESCRIPTION         : Receives Message from Plugins, and forwards the data to Plugin Server
* AUTHOR              : Shanmugapriya Murugan
* Date                : 20.11.2018
* Revision History    : 0.1
* Date 20.11.2018     : Initial version
****************************************************************************/


#ifndef _COMMON_PLUGIN_H
#define _COMMON_PLUGIN_H

#include <iostream>
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"

class CommonPlugin
{
public:
    ~CommonPlugin();
    static CommonPlugin* getInstance();
    virtual void setPluginData(std::string pluginName, std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
    virtual void setPluginListData(std::string pluginName, std::string key, const boost::shared_ptr<EventDataUtility>& eValue, const boost::shared_ptr<EventListDataUtility>& eListData);
private:
    CommonPlugin();
};
#endif
