/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CommonPlugin.cpp
* COMPONENT Name      : CommandUtilities
* DESCRIPTION         : Receives Message from Plugins, and forwards the data to Plugin Server
* AUTHOR              : Shanmugapriya Murugan
* Date                : 20.11.2018
* Revision History    : 0.1
* Date 20.11.2018     : Initial version
****************************************************************************/

#include "CommonPlugin.h"
#include "PluginServerHandler.h"
#include "plugin_trace.h"
#include "PluginConstants.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_APPUTILITIES_COMMANDUTILITIES
#include "trcGenProj/Header/CommonPlugin.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

/************************************************************************
*NAME        : CommonPlugin
*DESCRIPTION : Design section 8.3.7 - CommonPlugin
************************************************************************/
CommonPlugin::CommonPlugin()
{
	ETG_TRACE_USR4(("CommonPlugin::CommonPlugin()"));
}

/************************************************************************
*NAME        : ~CommonPlugin
*DESCRIPTION : Design section 8.3.7 - CommonPlugin
************************************************************************/
CommonPlugin::~CommonPlugin()
{
	ETG_TRACE_USR4(("CommonPlugin::~CommonPlugin()"));
}


/************************************************************************
*NAME        : getInstance
*DESCRIPTION : Design section 8.3.7 - CommonPlugin
************************************************************************/
CommonPlugin* CommonPlugin::getInstance()
{
	ETG_TRACE_USR4(("CommonPlugin::poGetInstance()"));
	static CommonPlugin commonPluginInstance;

	return &commonPluginInstance;
}

/************************************************************************
*NAME        : setPluginData
*DESCRIPTION : Design section 8.3.7 - CommonPlugin
************************************************************************/
void CommonPlugin::setPluginData(std::string pluginName, std::string key, const boost::shared_ptr<EventDataUtility>& eValue)
{

    ETG_TRACE_USR4(("CommonPlugin::setPluginData(), pluginName: %s ",pluginName.c_str()));
    ETG_TRACE_USR4(("CommonPlugin::setPluginData(), controlBlockName: %s ",key.c_str()));
    PluginServerHandler* ptrPluginServer = PluginServerHandler::getInstance();
    if(NULL != ptrPluginServer)
    {
	if (0 == pluginName.compare("StationList"))
	{
		ETG_TRACE_USR4(("CommonPlugin::setPluginData(), pluginName:pluginName == STATION_LIST_DATA"));
		ptrPluginServer->EndStationListUpdateProperty(eValue);
	}
	else
	{ 
		ETG_TRACE_USR4(("CommonPlugin::setPluginData(), pluginName:pluginName != STATION_LIST_DATA"));
	 	ptrPluginServer->onPluginUpdateSignal(pluginName, key, eValue);
	}	
    }

}

/************************************************************************
*NAME        : setPluginListData
*DESCRIPTION : Design section 8.3.7 - CommonPlugin
************************************************************************/
void CommonPlugin::setPluginListData(std::string pluginName, std::string key, const boost::shared_ptr<EventDataUtility>& eValue,
		const boost::shared_ptr<EventListDataUtility>& eData)
{
    ETG_TRACE_USR4(("CommonPlugin::setPluginListData(), pluginName: %s ",pluginName.c_str()));
    ETG_TRACE_USR4(("CommonPlugin::setPluginListData(), controlBlockName: %s ",key.c_str()));
    PluginServerHandler* ptrPluginServer = PluginServerHandler::getInstance();
    if(NULL != ptrPluginServer)
    {
        if (0 == pluginName.compare("EntityList"))
	    {
		   ptrPluginServer->EntityDetailsListUpdateProperty(eData);
	    }
	    else
		{
           ptrPluginServer->onPluginListUpdateSignal(pluginName, key, eValue, eData);
		}
    }
}
