/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginDataConverter.h
* COMPONENT Name      : PluginDataConverter
* DESCRIPTION         : Data coversion class used by PluginClientHandler and PluginServerHandler
*						      Converts data packed in EventDataUtility into Dbus variant data and vice versa
* AUTHOR              : Preethi Alagappan
* Date                : 15.10.2018
* Revision History    : 0.1
* Date 15.10.2018     : Initial version
* Revision History    : 0.2
* Date 15.11.2018     : Implementation for list data conversion
****************************************************************************/

#ifndef PLUGIN_DATA_CONVERTER_HEADER
#define PLUGIN_DATA_CONVERTER_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"
#include "VariantWriter.h"
#include "VariantReader.h"

class PluginDataConverter
{
public:
   static bool convertToVariant(const boost::shared_ptr<EventDataUtility>& dataUtility,
                                ::asf::dbus::DBusVariant& variant);

   static bool convertToListVariant(const boost::shared_ptr<EventListDataUtility>& listDataUtility,
                                    ::asf::dbus::DBusVariant& variant);

   static bool convertToEventDataUtility(::asf::dbus::DBusVariant variant,
                                         boost::shared_ptr<EventDataUtility>& dataUtility);

   static bool convertToEventListDataUtility(::asf::dbus::DBusVariant variant,
                                             boost::shared_ptr<EventListDataUtility>& listDataUtility);

private:
   PluginDataConverter(){};

   static bool getArraySignature(const EventDataUtility* dataUtility, std::string& typeSpecifier);
   static bool writeArrayStructData(const EventDataUtility* dataUtility, VariantWriter *writer, const std::string& typeSpecifier);

   static bool writeStructData(const EventDataUtility* dataUtility, VariantWriter *writer);
   static bool readStructData(VariantReader *reader, const std::string& typeSpecifier, EventDataUtility* dataUtility);
};

#endif
