/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : VariantWriter.h
* COMPONENT Name      : dbus_variant_helper
* DESCRIPTION         : Wrapper class for MessageIterWriter. Writes data into variant
* AUTHOR              : Preethi Alagappan
* Date                : 10.09.2018
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Modified method signature for container related functions
*                     : Added new method insert_array_uint8() and insert_double()
****************************************************************************/

#ifndef VARIANTWRITER_H
#define VARIANTWRITER_H

#include <stack>
#include "MessageIterWriter.h"

class VariantWriter
{
public:
	VariantWriter(::asf::dbus::DBusVariant& variant);
	~VariantWriter();
	
	bool insert_bool  (const bool&   value);
	bool insert_uint8 (const uint8&  value);
	bool insert_uint16(const uint16& value);
	bool insert_uint32(const uint32& value);
	bool insert_uint64(const uint64& value);
	bool insert_double(const double& value);
	bool insert_string(const std::string& value);
	
	bool insert_array_uint8 (const uint8**  values, int numElems);
	bool insert_array_uint16(const uint16** values, int numElems);
	bool insert_array_uint32(const uint32** values, int numElems);

	bool insert_array_uint8 (const std::vector<uint8>&  values);
	bool insert_array_uint16(const std::vector<uint16>& values);
	bool insert_array_uint32(const std::vector<uint32>& values);
	bool insert_array_string(const std::vector<std::string>& values);	
	
	bool open_array  (const char* signature);
	bool open_variant(const char* signature);
	bool open_struct();
	bool open_dict_entry();
	
	bool close_array();
	bool close_variant();
	bool close_struct();
	bool close_dict_entry();
		
private:
	VariantWriter(){}
	bool close_container();
	
	std::stack<MessageIterWriter *> stackIter;
};

#endif
