/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : VariantReader.h
* COMPONENT Name      : dbus_variant_helper
* DESCRIPTION         : Wrapper class for MessageIterReader. Reads data from variant
* AUTHOR              : Preethi Alagappan
* Date                : 10.09.2018
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Modified method signature for container related functions
*                     : Added new method get_array_uint8() and get_double()
****************************************************************************/

#ifndef VARIANTREADER_H
#define VARIANTREADER_H

#include <stack>
#include "MessageIterReader.h"

class VariantReader
{
public:
	VariantReader(::asf::dbus::DBusVariant& variant);
	~VariantReader();
	
	bool at_end();
	
	bool get_bool  (bool*   value);
	bool get_uint8 (uint8*  value);
	bool get_uint16(uint16* value);
	bool get_uint32(uint32* value);
	bool get_uint64(uint64* value);
	bool get_double(double* value);
	bool get_string(std::string* value);
	
	bool get_array_uint8 (uint8**  values, int* numElems);
	bool get_array_uint16(uint16** values, int* numElems);
	bool get_array_uint32(uint32** values, int* numElems);

	bool get_array_uint8 (std::vector<uint8>*  values);
	bool get_array_uint16(std::vector<uint16>* values);
	bool get_array_uint32(std::vector<uint32>* values);
	bool get_array_string(std::vector<std::string>* values);
	
	bool open_array();
	bool open_variant();
	bool open_struct();
	bool open_dict_entry();
	
	void close_array();
	void close_variant();
	void close_struct();
	void close_dict_entry();
	
private:
	VariantReader();
	void close_container();
	
	std::stack<MessageIterReader *> stackIter;
};

#endif
