/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : MessageIterWriter.h
* COMPONENT Name      : dbus_variant_helper
* DESCRIPTION         : Writes data into variant
* AUTHOR              : Preethi Alagappan
* Date                : 10.09.2018
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Modified method signature for container related functions
*                     : Added new method append_array_uint8() and append_double()
****************************************************************************/

#ifndef MESSAGEITERWRITER_H
#define MESSAGEITERWRITER_H

#include <vector>
#include <iostream>
#include <string>
#include "asf/dbus/DBusVariant.h"

class MessageIterWriter
{
public:
	MessageIterWriter();
	MessageIterWriter(DBusMessageIter *iter);
	~MessageIterWriter();
	DBusMessageIter* getIterator();
	
	bool append_bool  (const bool&   value);
	bool append_uint8 (const uint8&  value);
	bool append_uint16(const uint16& value);
	bool append_uint32(const uint32& value);
	bool append_uint64(const uint64& value);
	bool append_double(const double& value);
	bool append_string(const std::string& value);
	
	bool append_array_uint8 (const uint8**  values, int numElems);
	bool append_array_uint16(const uint16** values, int numElems);
	bool append_array_uint32(const uint32** values, int numElems);

	bool append_array_uint8 (const std::vector<uint8>&       values);
	bool append_array_uint16(const std::vector<uint16>&      values);
	bool append_array_uint32(const std::vector<uint32>&      values);
	bool append_array_string(const std::vector<std::string>& values);	
	
	bool new_array     (const char* signature, MessageIterWriter* subIter);
	bool new_variant   (const char* signature, MessageIterWriter* subIter);
	bool new_struct    (MessageIterWriter* subIter);
	bool new_dict_entry(MessageIterWriter* subIter);
	
	bool delete_container(MessageIterWriter* subIter);
	
private:
	bool append_basic(int type_id, const void* value);
	bool append_array(int type_id, const void* values, int numElems);
		
	DBusMessageIter memberIter;
	DBusMessageIter *iter;
};

#endif
