/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : MessageIterReader.h
* COMPONENT Name      : dbus_variant_helper
* DESCRIPTION         : Reads data from variant
* AUTHOR              : Preethi Alagappan
* Date                : 10.09.2018
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Modified method signature for container related functions
*                     : Added new method get_array_uint8() and get_double()
****************************************************************************/

#ifndef MESSAGEITERREADER_H
#define MESSAGEITERREADER_H

#include <vector>
#include <iostream>
#include <string>
#include "asf/dbus/DBusVariant.h"

using namespace std;

class MessageIterReader
{
   public:
      MessageIterReader();
      MessageIterReader(DBusMessageIter* iter);
      ~MessageIterReader();
      DBusMessageIter* getIterator();

      int get_type();
      int get_array_type();
      bool at_end();
      bool has_next();
      bool goto_next();

      bool get_bool  (bool*   value);
      bool get_uint8 (uint8*  value);
      bool get_uint16(uint16* value);
      bool get_uint32(uint32* value);
      bool get_uint64(uint64* value);
      bool get_double(double* value);
      bool get_string(string* value);

      bool get_array_uint8 (uint8**  values, int* numElems);
      bool get_array_uint16(uint16** values, int* numElems);
      bool get_array_uint32(uint32** values, int* numElems);

      bool get_array_uint8 (vector<uint8>*  values);
      bool get_array_uint16(vector<uint16>* values);
      bool get_array_uint32(vector<uint32>* values);
      bool get_array_string(vector<string>* values);

      bool open_array     (MessageIterReader* subIter);
      bool open_variant   (MessageIterReader* subIter);
      bool open_struct    (MessageIterReader* subIter);
      bool open_dict_entry(MessageIterReader* subIter);

   private:
      bool is_array_type_fixed(int type_id);
      bool get_basic(int type_id, void* value);
      bool get_array_basic(int type_id, void* value, int* numElems);
      void recurse(DBusMessageIter* subIter);

      DBusMessageIter memberIter;
      DBusMessageIter *iter;
};

#endif
