/**************************************************************************
 * FILE:         scd.h
 * SW-COMPONENT: 
 * DESCRIPTION:  
 * AUTHOR:       K7/EFT21-Kuhn
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim 
 * HISTORY:      
 * 30.11.2000 Rev.1.0 K7/EFT21-Kuhn 
 *            initial revision
 * 26.04.2001 Rev.1.1 K7/EFT21-Bruns
 *            adapted for project files which support WinCE + WinNT
 * 25.05.2001 Rev.1.2 K7/EFG32-Kuhn 
 *            some deinitions changed to confirme with cca-paper
 * 09.03.2011 CM-AI/PJ-GM54 Creux
 *            new parameter for bGetAppIdFromServiceId()
 * 
 *************************************************************************/

#ifndef SCD_HEADER  
#define SCD_HEADER  

#ifdef __cplusplus
extern "C"{
#endif

/*************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|*************************************************************************/
/*none*/

/*************************************************************************
| defines and macros (scope: global)
|*************************************************************************/

// TR_CLASS_AIL                 TR_COMP_CCA + 0 = 0x8A00
// TR_CLASS_SCD                 TR_COMP_CCA + 1 = 0x8A01
// TR_CLASS_AMT                 TR_COMP_CCA + 2 = 0x8A02
// TR_CLASS_AHL_CCA_EXTENSION   TR_COMP_CCA + 3 = 0x8A03
#define TR_CLASS_SCD                  ((TR_tenTraceClass)(TR_COMP_CCA + 1))

//default settings, actual value from registry
#define SCD_MAILBOX_MAX_MESSAGE_COUNT  20  //messages
#define SCD_MAILBOX_MAX_MESSAGE_LENGTH (sizeof(OSAL_trMessage)) //bytes /* CCA-handle size!! udo changes here */
#define SCD_MESSAGE_POOL_SIZE          300000 //bytes

/*************************************************************************
| typedefs (scope: global)
|*************************************************************************/
typedef struct
{ 
   tU16 u16AppId;
} trScdAppInfo;

typedef struct
{
   tU32 u32MsgCountIntermediateMbx;
   tU32 u32WatchdogInterval;
} scd_trAppInterfaceConfiguration;

/*************************************************************************
| variable declaration (scope: global)
|*************************************************************************/
/*none*/

/*************************************************************************
| function prototypes (scope: global)
|*************************************************************************/
tU32   scd_u32GetNbrOfAppIds         (tU16 u16ServiceId);
tBool  scd_bGetAppIdFromServiceId    (  tU16 u16ServiceId, 
                                                tU32 *pu32NbrOfAppInfos, 
                                                trScdAppInfo *prScdAppInfo,
												tBool bReadRegistry = TRUE);
OSAL_tMQueueHandle scd_OpenQueue     (tU16 u16AppId);
tS32   scd_s32CloseQueue             (OSAL_tMQueueHandle queueHdl);

tBool  scd_bCreateQueue              (tU16 u16AppId);
tS32   scd_s32DeleteQueue            (tU16 u16AppId);


 tBool scd_init( tVoid );
 tVoid scd_exit( tVoid );

 tBool scd_bGetAppInterfaceConfiguration(  tU16 u16AppID,
                                 scd_trAppInterfaceConfiguration * prAIFConf);

 tS32  scd_s32GetThreadConfiguration (  tU16 u16AppId,
                                                tCString coszName,
                                                tPU32 pu32Priority,
                                                tPS32 ps32Stacksize,
                                                OSAL_tMSecond *pWdgInterval = OSAL_NULL,
                                                OSAL_tMSecond *pMaxWdgInterval = OSAL_NULL );

 tBool scd_bGetSWBlockID(tU16 AppID, tU32* pu32SWBlockID);

 tBool scd_bGetAppConfigurationValue( tU16 u16AppID, tCString coszKeyName, tCString coszValueName, tPU32 pu32Value);
 tBool scd_bGetAppConfigurationString( tU16 u16AppID, tCString coszKeyName, tCString coszValueName, tString szOutputString, tU32 u32MaxLength);
 tBool scd_bGetProcConfigurationValue( tU16 u16AppID, tCString coszKeyName, tCString coszValueName, tPU32 pu32Value);
 tBool scd_bGetProcConfigurationString( tU16 u16AppID, tCString coszKeyName, tCString coszValueName, tString szOutputString, tU32 u32MaxLength);

 tBool scd_bAppRegistryAvailable (tU16 u16AppID);
                                 

tVoid dummy_scd_dll(tVoid);


/*************************************************************************/
#ifdef __cplusplus
}
#endif

#else
  #error scd.h included several times
#endif
