/************************************************************************
 * FILE:         reg_Iterator.cpp
 * PROJECT:      VASCO
 * SW-COMPONENT: REG
 *----------------------------------------------------------------------
 * DESCRIPTION:  Encapsulation of Blaupunkt's Registry
 *
 *               The registry is needed for initialisation of
 *               message queues at system setup (see scd-library).
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 03.04.01  |   Initial revision                     | Bruns,EFG32
 *
 *************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define SYSTEM_S_IMPORT_INTERFACE_REGISTRY
#include "system_pif.h"
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"


//-----------------------------------------------------------------------------
// reg_tclProcessIterator
//-----------------------------------------------------------------------------
reg_tclProcessIterator::reg_tclProcessIterator()
: reg_tclSubKeyIterator<reg_tclProcess>(OSAL_C_STRING_DEVICE_REGISTRY "/" REGSTRING_LOCAL_MACHINE "/"  REGKEY_PROCESS)
{
}



//-----------------------------------------------------------------------------
// reg_tclApplicationIterator
//-----------------------------------------------------------------------------
reg_tclApplicationIterator::reg_tclApplicationIterator(const reg_tclProcess &rfcooOrigin)
: reg_tclSubKeyIterator<reg_tclApplication>(rfcooOrigin)
{
}


//-----------------------------------------------------------------------------
// reg_tclServiceIterator
//-----------------------------------------------------------------------------
reg_tclServiceIterator::reg_tclServiceIterator(const reg_tclApplication &rfcooOrigin)
: reg_tclSubKeyIterator<reg_tclService>(rfcooOrigin)
{
   tChar szTempKeyName[REG_C_U32_KEYNAME_MAXLEN];

   tU32 u32StringLength = (tU32)OSAL_u32StringLength(szCurrentKeyName);
   u32StringLength = u32StringLength>(REG_C_U32_KEYNAME_MAXLEN-1)?(REG_C_U32_KEYNAME_MAXLEN-1):u32StringLength;
   OSAL_szStringNCopy(szTempKeyName, szCurrentKeyName, u32StringLength); //lint !e522: Expected void type, assignment, increment or decrement
   szTempKeyName[u32StringLength]='\0';
   tU32 u32PrefixLength = (tU32)OSAL_u32StringLength("/" REGKEY_SERVICES);
   u32PrefixLength = (u32PrefixLength > ((REG_C_U32_KEYNAME_MAXLEN-u32StringLength)-1)) ? ((REG_C_U32_KEYNAME_MAXLEN-u32StringLength)-1) : u32PrefixLength;
   OSAL_szStringNConcat(szTempKeyName, "/" REGKEY_SERVICES, u32PrefixLength); //lint !e522: Expected void type, assignment, increment or decrement
   szTempKeyName[u32StringLength+u32PrefixLength]='\0';
   bSetAt(szTempKeyName);
}




