/*****************************************************************************
 * FILE:         reg_ifRegKey.h
 * PROJECT:      VASCO
 * SW-COMPONENT: REG
 *----------------------------------------------------------------------------
 * DESCRIPTION:  Encapsulation of registry commands
 *
 *               USES: fwl_List
 *                     pc_types
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 02.04.01  |   Initial revision                     | Bruns,EFG32
 * 01.04.03  |   use system_pif-header for defines    | Fischer, CM-DI/ESA1
 *           |   use osal-functions
 * 02.04.03  |   terminate strings                    | Fischer, CM-DI/ESA1
 *****************************************************************************/


#ifndef REG_IFREGKEY_H
#define REG_IFREGKEY_H

// The following define limits the maximum key length
#define REG_C_U32_KEYNAME_MAXLEN (tU32)255

//-----------------------------------------------------------------------------
// class "reg_ifRegKey"
//
// interface for registry class
//-----------------------------------------------------------------------------
class reg_ifRegKey
{
   public:

      // default constructor
      reg_ifRegKey () {;}
      // constructor
      reg_ifRegKey (const tChar *coszHKeyQualifier) {(void)coszHKeyQualifier;}
      // copy constrcutor
      //reg_ifRegKey (const reg_ifRegKey &roSource) {return;}
      // destructor
      virtual ~reg_ifRegKey ()  {;}

      //virtual reg_ifRegKey& operator= (const reg_ifRegKey&) = 0;

      // create a key
      virtual tBool bCreate    (const tChar *coszKeyName) = 0;
      virtual tBool bRelCreate (const tChar *coszRelKeyName) = 0;

      // open a key
      virtual tBool bOpen    (const tChar *coszRelKeyName) = 0;
      virtual tBool bOpen    (const tChar *coszParentName, const tChar *coszSubKeyName) = 0;
      virtual tBool bOpen    (const reg_ifRegKey &roSource) = 0;
      virtual tBool bOpen    (const reg_ifRegKey &roSource, const tChar *coszSubKeyName) = 0;
      virtual tBool bRelOpen (const tChar *coszRelKeyName) = 0;

      // close a key
      virtual tVoid vClose (tVoid) = 0;

      // set a value/string for a key
      virtual tBool bSetU32    (const tChar *coszKeyName, tU32 u32NewValue) = 0;
      virtual tBool bSetString (const tChar *coszKeyName, tChar *szString, tU32 u32StringLen) = 0;

      // queries for value/string 
      virtual tBool bQueryU32    (const tChar *coszKeyName, tU32 *rdwResult) = 0;
      virtual tBool bQueryString (const tChar *coszKeyName, tChar *rdwResult, tU32 u32MaxBufLen) = 0;

      // retrieves current key name "oCurrentKeyName" as string (absolute name)
      virtual tBool bGetCurrentKeyName (tChar *pcBuffer, tU32 u32MaxLen) const = 0;
      virtual tBool bSetCurrentKeyName (const tChar *pcNewKey) = 0;

      // retrieves current key name as string (relative name)
      virtual tBool bGetLastKeyName (tChar *pcBuffer, tU32 u32MaxLen) const = 0;

      /**
       * navigates the registry path one Kep up (to the root)
       * Note: if the key was open before it closed after
       *
       * @return  TRUE    if navigation was possible. otherwise the 
       *                  result is FALSE object is unchanged
       *
       * @author CM-DI/PJ-CF11-Wiedemann
       * @date   05.09.2007
       */      
      virtual tBool bNavigateKeyNameUp () = 0;

      // return TRUE if oHKey != OSAL_NULL (the key is valid)
      virtual tBool bIsValid (tVoid) = 0;
      
      // return pointer to the currently set KeyNameObject
      virtual const tChar* cpGetClassKeyName() const = 0;
};

#endif //REG_IFREGKEY_H

