/*****************************************************************************
 * FILE:         regRegistry.h
 * PROJECT:      VASCO
 * SW-COMPONENT: REG
 *----------------------------------------------------------------------------
 * DESCRIPTION:  Encapsulation of registry commands
 *
 *               USES: fwl_List
 *                     pc_types
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 02.04.01  |   Initial revision                     | Bruns,EFG32
 * 01.04.03  |   use system_pif-header for defines    | Fischer, CM-DI/ESA1
 *           |   use osal-functions
 * 02.04.03  |   terminate strings                    | Fischer, CM-DI/ESA1
 *****************************************************************************/


#ifndef REGREGISTRY_H
#define REGREGISTRY_H

#include "reg_ifRegKey.h"

//-----------------------------------------------------------------------------
// class "reg_tclRegistry"
//
// Encapsulation of registry functions
//-----------------------------------------------------------------------------
class reg_tclRegKey: public reg_ifRegKey
{
   private:

      // current descriptor
      OSAL_tIODescriptor fd;
      tBool bOpenLocal();

   protected:
      // current name
      tChar szCurrentKeyName[REG_C_U32_KEYNAME_MAXLEN];

   public:

      // default constructor
      reg_tclRegKey ();
      // constructor
      reg_tclRegKey (const tChar *coszHKeyQualifier);
      // copy constrcutor
      reg_tclRegKey (const reg_tclRegKey &roSource);
      // destructor
      virtual ~reg_tclRegKey ();

      reg_tclRegKey& operator= (const reg_tclRegKey&);

      // create a key
      virtual tBool bCreate    (const tChar *coszKeyName);
      virtual tBool bRelCreate (const tChar *coszRelKeyName);

      // open a key
      virtual tBool bOpen    (const tChar *coszRelKeyName);
      virtual tBool bOpen    (const tChar *coszParentName, const tChar *coszSubKeyName);
      virtual tBool bOpen    (const reg_ifRegKey &roSource);
      virtual tBool bOpen    (const reg_ifRegKey &roSource, const tChar *coszSubKeyName);
      virtual tBool bRelOpen (const tChar *coszRelKeyName);

      // close a key
      virtual tVoid vClose (tVoid);

      // set a value/string for a key
      virtual tBool bSetU32    (const tChar *coszKeyName, tU32 u32NewValue);
      virtual tBool bSetString (const tChar *coszKeyName, tChar *szString, tU32 u32StringLen);

      // queries for value/string 
      virtual tBool bQueryU32    (const tChar *coszKeyName, tU32 *rdwResult);
      virtual tBool bQueryString (const tChar *coszKeyName, tChar *rdwResult, tU32 u32MaxBufLen);

      // retrieves current key name "oCurrentKeyName" as string (absolute name)
      virtual tBool bGetCurrentKeyName (tChar *pcBuffer, tU32 u32MaxLen) const;
      virtual tBool bSetCurrentKeyName (const tChar *pcNewKey);

      // retrieves current key name as string (relative name)
      virtual tBool bGetLastKeyName (tChar *pcBuffer, tU32 u32MaxLen) const;

      /**
       * navigates the registry path one Kep up (to the root)
       * Note: if the key was open before it closed after
       *
       * @return  TRUE    if navigation was possible. otherwise the 
       *                  result is FALSE object is unchanged
       *
       * @author CM-DI/PJ-CF11-Wiedemann
       * @date   05.09.2007
       */      
      virtual tBool bNavigateKeyNameUp ();

      // return TRUE if oHKey != OSAL_NULL (the key is valid)
      virtual tBool bIsValid (tVoid);

      virtual const tChar* cpGetClassKeyName() const {return szCurrentKeyName;}
};

#endif //REGREGISTRY_H

